/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.FreemarkerTemplateQuery;
import com.slyak.spring.jpa.TemplateQuery;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class TemplateQueryLookupStrategy
implements QueryLookupStrategy {
    private final EntityManager entityManager;
    private QueryLookupStrategy jpaQueryLookupStrategy;
    private QueryExtractor extractor;

    public TemplateQueryLookupStrategy(EntityManager entityManager, QueryLookupStrategy.Key key, QueryExtractor extractor, EvaluationContextProvider evaluationContextProvider) {
        this.jpaQueryLookupStrategy = JpaQueryLookupStrategy.create((EntityManager)entityManager, (QueryLookupStrategy.Key)key, (QueryExtractor)extractor, (EvaluationContextProvider)evaluationContextProvider);
        this.extractor = extractor;
        this.entityManager = entityManager;
    }

    public static QueryLookupStrategy create(EntityManager entityManager, QueryLookupStrategy.Key key, QueryExtractor extractor, EvaluationContextProvider evaluationContextProvider) {
        return new TemplateQueryLookupStrategy(entityManager, key, extractor, evaluationContextProvider);
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        if (method.getAnnotation(TemplateQuery.class) == null) {
            return this.jpaQueryLookupStrategy.resolveQuery(method, metadata, factory, namedQueries);
        }
        return new FreemarkerTemplateQuery(new JpaQueryMethod(method, metadata, factory, this.extractor), this.entityManager);
    }
}

