/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.NamedTemplateCallback;
import com.slyak.spring.jpa.NamedTemplateResolver;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;

public class SftlNamedTemplateResolver
implements NamedTemplateResolver {
    private String encoding = "UTF-8";

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public Iterator<Void> doInTemplateResource(Resource resource, final NamedTemplateCallback callback) throws Exception {
        InputStream inputStream = resource.getInputStream();
        final List lines = IOUtils.readLines((InputStream)inputStream, (String)this.encoding);
        return new Iterator<Void>(){
            String name;
            StringBuilder content = new StringBuilder();
            int index = 0;
            int total = lines.size();

            @Override
            public boolean hasNext() {
                return this.index < this.total;
            }

            @Override
            public Void next() {
                do {
                    String line;
                    if (this.isNameLine(line = (String)lines.get(this.index))) {
                        this.name = StringUtils.trim((String)StringUtils.remove((String)line, (String)"--"));
                    } else if ((line = StringUtils.trimToNull((String)line)) != null) {
                        this.content.append(line).append(" ");
                    }
                    ++this.index;
                } while (!this.isLastLine() && !this.isNextNameLine());
                callback.process(this.name, this.content.toString());
                this.name = null;
                this.content = new StringBuilder();
                return null;
            }

            @Override
            public void remove() {
            }

            private boolean isNameLine(String line) {
                return StringUtils.contains((CharSequence)line, (CharSequence)"--");
            }

            private boolean isNextNameLine() {
                String line = (String)lines.get(this.index);
                return this.isNameLine(line);
            }

            private boolean isLastLine() {
                return this.index == this.total;
            }
        };
    }
}

