/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.BeanTransformerAdapter;
import com.slyak.spring.jpa.SmartTransformer;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class QueryBuilder {
    private static final Pattern ORDERBY_PATTERN_1 = Pattern.compile("order\\s+by.+?$", 34);

    public static <C> Query transform(Query query, Class<C> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        }
        if (Number.class.isAssignableFrom(clazz) || clazz.isPrimitive() || String.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz)) {
            return query.setResultTransformer((ResultTransformer)new SmartTransformer(clazz));
        }
        return query.setResultTransformer(new BeanTransformerAdapter<C>(clazz));
    }

    public static SQLQuery toSQLQuery(EntityManager em, String nativeQuery, Object beanOrMap) {
        Session session = (Session)em.unwrap(Session.class);
        SQLQuery query = session.createSQLQuery(nativeQuery);
        QueryBuilder.setParams(query, beanOrMap);
        return query;
    }

    private static String wrapCountQuery(String query) {
        return "select count(*) from (" + query + ") as ctmp";
    }

    private static String cleanOrderBy(String query) {
        Matcher matcher = ORDERBY_PATTERN_1.matcher(query);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (matcher.find()) {
            String part = matcher.group(i);
            if (QueryBuilder.canClean(part)) {
                matcher.appendReplacement(sb, "");
            } else {
                matcher.appendReplacement(sb, part);
            }
            ++i;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static boolean canClean(String orderByPart) {
        return orderByPart != null && (!orderByPart.contains(")") || StringUtils.countOccurrencesOf((String)orderByPart, (String)")") == StringUtils.countOccurrencesOf((String)orderByPart, (String)"("));
    }

    public static String toCountQuery(String query) {
        return QueryBuilder.wrapCountQuery(QueryBuilder.cleanOrderBy(query));
    }

    public static void setParams(SQLQuery query, Object beanOrMap) {
        String[] nps = query.getNamedParameters();
        if (nps != null) {
            Map<String, Object> params = QueryBuilder.toParams(beanOrMap);
            for (String key : nps) {
                Object arg = params.get(key);
                if (arg == null) {
                    query.setParameter(key, null);
                    continue;
                }
                if (arg.getClass().isArray()) {
                    query.setParameterList(key, (Object[])arg);
                    continue;
                }
                if (arg instanceof Collection) {
                    query.setParameterList(key, (Collection)arg);
                    continue;
                }
                if (arg.getClass().isEnum()) {
                    query.setParameter(key, (Object)((Enum)arg).ordinal());
                    continue;
                }
                query.setParameter(key, arg);
            }
        }
    }

    public static Map<String, Object> toParams(Object beanOrMap) {
        Map<String, Object> params = beanOrMap instanceof Map ? (Map<String, Object>)beanOrMap : QueryBuilder.toMap(beanOrMap);
        if (!CollectionUtils.isEmpty(params)) {
            Iterator<String> keys = params.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                if (QueryBuilder.isValidValue(params.get(key))) continue;
                keys.remove();
            }
        }
        return params;
    }

    public static boolean isValidValue(Object object) {
        if (object == null) {
            return false;
        }
        return !(object instanceof Collection) || !CollectionUtils.isEmpty((Collection)((Collection)object));
    }

    public static Map<String, Object> toMap(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            HashMap<String, Object> description = new HashMap<String, Object>();
            if (bean instanceof DynaBean) {
                DynaProperty[] descriptors;
                for (DynaProperty descriptor : descriptors = ((DynaBean)bean).getDynaClass().getDynaProperties()) {
                    String name = descriptor.getName();
                    description.put(name, BeanUtils.getProperty((Object)bean, (String)name));
                }
            } else {
                PropertyDescriptor[] descriptors;
                for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors((Object)bean)) {
                    String name = descriptor.getName();
                    if (PropertyUtils.getReadMethod((PropertyDescriptor)descriptor) == null) continue;
                    description.put(name, PropertyUtils.getNestedProperty((Object)bean, (String)name));
                }
            }
            return description;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static void main(String[] args) {
        String t1 = "select * from user order by id";
        String t2 = "select * from abc order by xxx(convert( resName using gbk )) collate gbk_chinese_ci asc";
        String t3 = "select count * from ((select * from aaa group by a order by a) union all (select * from aaa group by a order by a))";
        String t4 = "SELECT\n  t1.*,t2.name AS dictionaryName,t3.name AS classifyName\nFROM res_data_element t1 LEFT JOIN sys_business_dictionary t2 ON  t1.dictionary_id = t2.id\n  LEFT JOIN sys_business_dictionary t3 ON  t1.classify = t3.id\nWHERE  1=1\n       AND  t1.is_history_version = 1\n       AND t1.status = 1\n       AND (t1.name LIKE '%${nameOrCodeOrENameOrCompany}%'\n         OR\n         t1.code LIKE '%${nameOrCodeOrENameOrCompany}%'\n         OR\n         t1.englishname LIKE '%${nameOrCodeOrENameOrCompany}%'\n         OR\n         t1.submit_company LIKE '%${nameOrCodeOrENameOrCompany}%')";
        System.out.println(QueryBuilder.toCountQuery(t1));
        System.out.println(QueryBuilder.toCountQuery(t2));
        System.out.println(QueryBuilder.toCountQuery(t3));
    }
}

