/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.GenericJpaRepository;
import com.slyak.spring.jpa.Status;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.springframework.beans.BeanUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

public class GenericJpaRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements GenericJpaRepository<T, ID>,
Serializable {
    private EntityManager em;
    private JpaEntityInformation<T, ID> eif;
    private boolean isStatusAble = false;
    private Method statusReadMethod;
    private Method statusWriteMethod;

    public GenericJpaRepositoryImpl(JpaEntityInformation<T, ID> eif, EntityManager em) {
        super(eif, em);
        this.em = em;
        this.eif = eif;
        PropertyDescriptor descriptor = this.findFieldPropertyDescriptor(eif.getJavaType(), Status.class);
        boolean bl = this.isStatusAble = descriptor != null;
        if (this.isStatusAble) {
            this.statusReadMethod = descriptor.getReadMethod();
            this.statusWriteMethod = descriptor.getWriteMethod();
        }
    }

    @Override
    public Map<ID, T> mget(Collection<ID> ids) {
        return this.toMap(this.findAll(ids));
    }

    @Override
    public Map<ID, T> mgetOneByOne(Collection<ID> ids) {
        return this.toMap(this.findAllOneByOne(ids));
    }

    @Override
    public List<T> findAllOneByOne(Collection<ID> ids) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Serializable id : ids) {
            Object one = this.findOne(id);
            if (one == null) continue;
            results.add(one);
        }
        return results;
    }

    private Map<ID, T> toMap(List<T> list) {
        LinkedHashMap<Serializable, T> result = new LinkedHashMap<Serializable, T>();
        for (T t : list) {
            if (t == null) continue;
            result.put(this.eif.getId(t), t);
        }
        return result;
    }

    @Override
    @Transactional
    public void toggleStatus(ID id) {
        Status status;
        Object target;
        if (this.isStatusAble && id != null && (target = this.findOne((Serializable)id)) != null && ((status = (Status)((Object)ReflectionUtils.invokeMethod((Method)this.statusReadMethod, (Object)target))) == Status.ENABLED || status == Status.DISABLED)) {
            ReflectionUtils.invokeMethod((Method)this.statusWriteMethod, (Object)target, (Object[])new Object[]{status == Status.DISABLED ? Status.ENABLED : Status.DISABLED});
            this.save(target);
        }
    }

    @Override
    @Transactional
    public void fakeDelete(ID ... ids) {
        for (ID id : ids) {
            this.changeStatus(id, Status.DELETED);
        }
    }

    private void changeStatus(ID id, Status status) {
        Status oldStatus;
        Object target;
        if (this.isStatusAble && id != null && (target = this.findOne((Serializable)id)) != null && (oldStatus = (Status)((Object)ReflectionUtils.invokeMethod((Method)this.statusReadMethod, (Object)target))) != status) {
            ReflectionUtils.invokeMethod((Method)this.statusWriteMethod, (Object)target, (Object[])new Object[]{status});
            this.save(target);
        }
    }

    private PropertyDescriptor findFieldPropertyDescriptor(Class target, Class fieldClass) {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor pd : propertyDescriptors = BeanUtils.getPropertyDescriptors((Class)target)) {
            if (pd.getPropertyType() != fieldClass) continue;
            return pd;
        }
        return null;
    }
}

