/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.ContextHolder;
import com.slyak.spring.jpa.EntityAssembler;
import com.slyak.spring.jpa.TemplateQueryLookupStrategy;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.AfterAdvice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.CollectionUtils;

public class GenericJpaRepositoryFactory
extends JpaRepositoryFactory {
    private final EntityManager entityManager;
    private final PersistenceProvider extractor;
    private Map<Class<?>, List<EntityAssembler>> assemblers = new ConcurrentHashMap();

    public GenericJpaRepositoryFactory(EntityManager entityManager) {
        super(entityManager);
        this.entityManager = entityManager;
        this.extractor = PersistenceProvider.fromEntityManager((EntityManager)entityManager);
        final AssemblerInterceptor assemblerInterceptor = new AssemblerInterceptor();
        this.addRepositoryProxyPostProcessor(new RepositoryProxyPostProcessor(){

            public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
                factory.addAdvice((Advice)assemblerInterceptor);
            }
        });
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return TemplateQueryLookupStrategy.create(this.entityManager, key, (QueryExtractor)this.extractor, evaluationContextProvider);
    }

    private List<EntityAssembler> getEntityAssemblers(Class<?> clazz) {
        if (this.assemblers.isEmpty()) {
            Collection<EntityAssembler> abs = ContextHolder.getBeansOfType(EntityAssembler.class);
            if (abs.isEmpty()) {
                return Collections.emptyList();
            }
            for (EntityAssembler entityAssembler : abs) {
                Class p0 = this.getGenericParameter0(entityAssembler.getClass());
                List<EntityAssembler> ass = this.assemblers.get(p0);
                if (ass == null) {
                    ass = new ArrayList<EntityAssembler>();
                    this.assemblers.put(p0, ass);
                }
                ass.add(entityAssembler);
            }
            for (List list : this.assemblers.values()) {
                Collections.sort(list, new Comparator<EntityAssembler>(){

                    @Override
                    public int compare(EntityAssembler o1, EntityAssembler o2) {
                        return OrderUtils.getOrder(o2.getClass()) - OrderUtils.getOrder(o1.getClass());
                    }
                });
            }
        }
        return this.assemblers.get(clazz);
    }

    private void massemble(Iterable iterable) {
        List<EntityAssembler> entityAssemblers;
        if (!iterable.iterator().hasNext()) {
            return;
        }
        Object object = iterable.iterator().next();
        if (this.isEntityObject(object) && !CollectionUtils.isEmpty(entityAssemblers = this.getEntityAssemblers(object.getClass()))) {
            for (EntityAssembler assembler : entityAssemblers) {
                assembler.massemble(iterable);
            }
        }
    }

    private boolean isEntityObject(Object object) {
        return object != null && AnnotationUtils.findAnnotation(object.getClass(), Entity.class) != null;
    }

    private Class getGenericParameter0(Class clzz) {
        return (Class)((ParameterizedType)clzz.getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public class AssemblerInterceptor
    implements MethodInterceptor,
    AfterAdvice {
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object proceed = invocation.proceed();
            if (!"save".equals(invocation.getMethod().getName()) && proceed != null) {
                List entityAssemblers;
                if (proceed instanceof Iterable) {
                    GenericJpaRepositoryFactory.this.massemble((Iterable)proceed);
                } else if (proceed instanceof Map) {
                    GenericJpaRepositoryFactory.this.massemble(((Map)proceed).values());
                } else if (GenericJpaRepositoryFactory.this.isEntityObject(proceed) && !CollectionUtils.isEmpty((Collection)(entityAssemblers = GenericJpaRepositoryFactory.this.getEntityAssemblers(proceed.getClass())))) {
                    for (EntityAssembler assembler : entityAssemblers) {
                        assembler.assemble(proceed);
                    }
                }
            }
            return proceed;
        }
    }
}

