/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.ContextHolder;
import com.slyak.spring.jpa.FreemarkerSqlTemplates;
import com.slyak.spring.jpa.QueryBuilder;
import com.slyak.util.AopTargetUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.SQLQuery;
import org.hibernate.jpa.internal.QueryImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.CollectionUtils;

public class FreemarkerTemplateQuery
extends AbstractJpaQuery {
    private boolean useJpaSpec = false;

    public FreemarkerTemplateQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
    }

    protected Query doCreateQuery(Object[] values) {
        Pageable pageable;
        String nativeQuery = this.getQuery(values);
        JpaParameters parameters = this.getQueryMethod().getParameters();
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)parameters, values);
        String sortedQueryString = QueryUtils.applySorting((String)nativeQuery, (Sort)accessor.getSort(), (String)QueryUtils.detectAlias((String)nativeQuery));
        Query query = this.bind(this.createJpaQuery(sortedQueryString), values);
        if (parameters.hasPageableParameter() && (pageable = (Pageable)values[parameters.getPageableIndex()]) != null) {
            query.setFirstResult(pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());
        }
        return query;
    }

    private String getQuery(Object[] values) {
        return this.getQueryFromTpl(values);
    }

    private String getQueryFromTpl(Object[] values) {
        return ContextHolder.getBean(FreemarkerSqlTemplates.class).process(this.getEntityName(), this.getMethodName(), this.getParams(values));
    }

    private Map<String, Object> getParams(Object[] values) {
        JpaParameters parameters = this.getQueryMethod().getParameters();
        Map<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            Object value = values[i];
            Parameter parameter = parameters.getParameter(i);
            if (value == null || !this.canBindParameter(parameter) || !QueryBuilder.isValidValue(value)) continue;
            Class<?> clz = value.getClass();
            if (clz.isPrimitive() || String.class.isAssignableFrom(clz) || Number.class.isAssignableFrom(clz) || clz.isArray() || Collection.class.isAssignableFrom(clz) || clz.isEnum()) {
                params.put(parameter.getName(), value);
                continue;
            }
            params = QueryBuilder.toParams(value);
        }
        return params;
    }

    public Query createJpaQuery(String queryString) {
        Query oriProxyQuery;
        Class objectType = this.getQueryMethod().getReturnedObjectType();
        if (this.useJpaSpec && this.getQueryMethod().isQueryForEntity()) {
            oriProxyQuery = this.getEntityManager().createNativeQuery(queryString, objectType);
        } else {
            Class genericType;
            oriProxyQuery = this.getEntityManager().createNativeQuery(queryString);
            QueryImpl query = (QueryImpl)AopTargetUtils.getTarget(oriProxyQuery);
            ClassTypeInformation ctif = ClassTypeInformation.from((Class)objectType);
            TypeInformation actualType = ctif.getActualType();
            if (actualType == null) {
                actualType = ctif.getRawTypeInformation();
            }
            if ((genericType = actualType.getType()) != null && genericType != Void.class) {
                QueryBuilder.transform(query.getHibernateQuery(), genericType);
            }
        }
        return oriProxyQuery;
    }

    private String getEntityName() {
        return this.getQueryMethod().getEntityInformation().getJavaType().getSimpleName();
    }

    private String getMethodName() {
        return this.getQueryMethod().getName();
    }

    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        TypedQuery query = (TypedQuery)this.getEntityManager().createNativeQuery(QueryBuilder.toCountQuery(this.getQuery(values)));
        this.bind((Query)query, values);
        return query;
    }

    public Query bind(Query query, Object[] values) {
        QueryImpl targetQuery = (QueryImpl)AopTargetUtils.getTarget(query);
        SQLQuery sqlQuery = (SQLQuery)targetQuery.getHibernateQuery();
        Map<String, Object> params = this.getParams(values);
        if (!CollectionUtils.isEmpty(params)) {
            QueryBuilder.setParams(sqlQuery, params);
        }
        return query;
    }

    protected boolean canBindParameter(Parameter parameter) {
        return parameter.isBindable();
    }
}

