/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.NamedTemplateCallback;
import com.slyak.spring.jpa.NamedTemplateResolver;
import com.slyak.spring.jpa.SftlNamedTemplateResolver;
import com.slyak.spring.jpa.XmlNamedTemplateResolver;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;

public class FreemarkerSqlTemplates
implements ResourceLoaderAware,
InitializingBean {
    private static Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    private static StringTemplateLoader sqlTemplateLoader = new StringTemplateLoader();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String encoding = "UTF-8";
    @PersistenceContext
    private EntityManager em;
    private Map<String, Long> lastModifiedCache = new ConcurrentHashMap<String, Long>();
    private Map<String, List<Resource>> sqlResources = new ConcurrentHashMap<String, List<Resource>>();
    private String templateLocation = "classpath:/sqls";
    private String templateBasePackage = "**";
    private ResourceLoader resourceLoader;
    private String suffix = ".xml";
    private Map<String, NamedTemplateResolver> suffixResolvers = new HashMap<String, NamedTemplateResolver>();

    public FreemarkerSqlTemplates() {
        this.suffixResolvers.put(".sftl", new SftlNamedTemplateResolver());
    }

    public String process(String entityName, String methodName, Map<String, Object> model) {
        this.reloadIfPossible(entityName);
        try {
            StringWriter writer = new StringWriter();
            cfg.getTemplate(this.getTemplateKey(entityName, methodName), this.encoding).process(model, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            this.logger.error((Object)("process template error. Entity name: " + entityName + " methodName:" + methodName), (Throwable)e);
            return "";
        }
    }

    private String getTemplateKey(String entityName, String methodName) {
        return entityName + ":" + methodName;
    }

    private void reloadIfPossible(final String entityName) {
        try {
            Long lastModified = this.lastModifiedCache.get(entityName);
            List<Resource> resourceList = this.sqlResources.get(entityName);
            long newLastModified = 0L;
            for (Resource resource : resourceList) {
                if (newLastModified == 0L) {
                    newLastModified = resource.lastModified();
                    continue;
                }
                newLastModified = newLastModified > resource.lastModified() ? newLastModified : resource.lastModified();
            }
            if (lastModified == null || newLastModified > lastModified) {
                this.lastModifiedCache.put(entityName, newLastModified);
                for (Resource resource : resourceList) {
                    Iterator<Void> iterator = this.suffixResolvers.get(this.suffix).doInTemplateResource(resource, new NamedTemplateCallback(){

                        @Override
                        public void process(String templateName, String content) {
                            String key = FreemarkerSqlTemplates.this.getTemplateKey(entityName, templateName);
                            Object src = sqlTemplateLoader.findTemplateSource(key);
                            if (src != null) {
                                FreemarkerSqlTemplates.this.logger.warn((Object)("found duplicate template key, will replace the value, key:" + key));
                            }
                            sqlTemplateLoader.putTemplate(FreemarkerSqlTemplates.this.getTemplateKey(entityName, templateName), content);
                        }
                    });
                    while (iterator.hasNext()) {
                        iterator.next();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        XmlNamedTemplateResolver xmlNamedTemplateResolver = new XmlNamedTemplateResolver(resourceLoader);
        xmlNamedTemplateResolver.setEncoding(this.encoding);
        this.suffixResolvers.put(".xml", xmlNamedTemplateResolver);
    }

    public void afterPropertiesSet() throws Exception {
        HashSet<String> names = new HashSet<String>();
        Set entities = this.em.getMetamodel().getEntities();
        for (EntityType entity : entities) {
            names.add(entity.getName());
        }
        String suffixPattern = "/**/*" + this.suffix;
        if (!names.isEmpty()) {
            String pattern;
            if (StringUtils.isNotBlank((CharSequence)this.templateBasePackage)) {
                pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)this.templateBasePackage) + suffixPattern;
                this.loadPatternResource(names, pattern);
            }
            if (StringUtils.isNotBlank((CharSequence)this.templateLocation)) {
                pattern = this.templateLocation.contains(this.suffix) ? this.templateLocation : this.templateLocation + suffixPattern;
                try {
                    this.loadPatternResource(names, pattern);
                }
                catch (FileNotFoundException e) {
                    if ("classpath:/sqls".equals(this.templateLocation)) {
                        this.logger.warn((Object)("templateLocation[" + this.templateLocation + "] not exist!"));
                        this.logger.warn((Object)e.getMessage());
                    }
                    throw e;
                }
            }
        }
    }

    private void loadPatternResource(Set<String> names, String pattern) throws IOException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        for (Resource resource : resources = resourcePatternResolver.getResources(pattern)) {
            String resourceName = resource.getFilename().replace(this.suffix, "");
            if (!names.contains(resourceName)) continue;
            List<Object> resourceList = null;
            if (this.sqlResources.containsKey(resourceName)) {
                resourceList = this.sqlResources.get(resourceName);
            } else {
                resourceList = new LinkedList();
                this.sqlResources.put(resourceName, resourceList);
            }
            resourceList.add(resource);
        }
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    public void setTemplateBasePackage(String templateBasePackage) {
        this.templateBasePackage = templateBasePackage;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    static {
        cfg.setTemplateLoader((TemplateLoader)sqlTemplateLoader);
    }
}

