/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.EntityAssembler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public abstract class EntityAssemblerOne<T, K, V>
implements EntityAssembler<T> {
    @Override
    public void assemble(T bean) {
        if (bean == null) {
            return;
        }
        K key = this.getKey(bean);
        if (key != null) {
            this.setValue(bean, this.getValue(key));
        }
    }

    @Override
    public void massemble(Iterable<T> beans) {
        if (beans == null) {
            return;
        }
        ArrayList<K> keys = new ArrayList<K>(32);
        for (T bean : beans) {
            K k = this.getKey(bean);
            if (bean == null || k == null) continue;
            keys.add(k);
        }
        if (keys.isEmpty()) {
            return;
        }
        if (!CollectionUtils.isEmpty(keys)) {
            Map map = this.mgetValue(keys);
            for (T bean : beans) {
                K k = this.getKey(bean);
                if (bean == null || k == null) continue;
                this.setValue(bean, map.get(k));
            }
        }
    }

    protected abstract K getKey(T var1);

    protected abstract void setValue(T var1, V var2);

    protected abstract V getValue(K var1);

    protected abstract Map<K, V> mgetValue(Collection<K> var1);
}

