/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.EntityAssembler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public abstract class EntityAssemblerMany<T, K, V>
implements EntityAssembler<T> {
    @Override
    public void assemble(T bean) {
        if (bean == null) {
            return;
        }
        this.setValue(bean, this.safeGetValue(this.getKeys(bean)));
    }

    @Override
    public void massemble(Iterable<T> beans) {
        if (beans == null || !beans.iterator().hasNext()) {
            return;
        }
        HashSet<K> keys = new HashSet<K>();
        for (T bean : beans) {
            List<K> ks;
            if (bean == null || CollectionUtils.isEmpty(ks = this.getKeys(bean))) continue;
            for (K k : ks) {
                keys.add(k);
            }
        }
        if (!CollectionUtils.isEmpty(keys)) {
            Map valueMap = this.mgetValue(keys);
            for (T bean : beans) {
                List<K> ks;
                if (bean == null || CollectionUtils.isEmpty(ks = this.getKeys(bean))) continue;
                ArrayList<V> values = new ArrayList<V>();
                for (K k : ks) {
                    values.add(valueMap.get(k));
                }
                this.setValue(bean, values);
            }
        }
    }

    protected abstract void setValue(T var1, List<V> var2);

    private List<V> safeGetValue(List<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyList();
        }
        return this.getValue(keys);
    }

    protected abstract List<V> getValue(List<K> var1);

    protected abstract List<K> getKeys(T var1);

    protected abstract Map<K, V> mgetValue(Collection<K> var1);
}

