/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.convert.JodaTimeConverters;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.StringUtils;

public class BeanTransformerAdapter<T>
implements ResultTransformer {
    private static DefaultConversionService conversionService = new DefaultConversionService();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class<T> mappedClass;
    private boolean checkFullyPopulated = false;
    private boolean primitivesDefaultedForNullValue = false;
    private Map<String, PropertyDescriptor> mappedFields;
    private Set<String> mappedProperties;

    public BeanTransformerAdapter() {
    }

    public BeanTransformerAdapter(Class<T> mappedClass) {
        this.initialize(mappedClass);
    }

    public BeanTransformerAdapter(Class<T> mappedClass, boolean checkFullyPopulated) {
        this.initialize(mappedClass);
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public static <T> BeanPropertyRowMapper<T> newInstance(Class<T> mappedClass) {
        BeanPropertyRowMapper newInstance = new BeanPropertyRowMapper();
        newInstance.setMappedClass(mappedClass);
        return newInstance;
    }

    protected void initialize(Class<T> mappedClass) {
        PropertyDescriptor[] pds;
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        this.mappedProperties = new HashSet<String>();
        for (PropertyDescriptor pd : pds = BeanUtils.getPropertyDescriptors(mappedClass)) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(pd.getName().toLowerCase(), pd);
            String underscoredName = this.underscoreName(pd.getName());
            if (!pd.getName().toLowerCase().equals(underscoredName)) {
                this.mappedFields.put(underscoredName, pd);
            }
            this.mappedProperties.add(pd.getName());
        }
    }

    private String underscoreName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(name.substring(0, 1).toLowerCase());
        for (int i = 1; i < name.length(); ++i) {
            String slc;
            String s = name.substring(i, i + 1);
            if (!s.equals(slc = s.toLowerCase())) {
                result.append("_").append(slc);
                continue;
            }
            result.append(s);
        }
        return result.toString();
    }

    public final Class<T> getMappedClass() {
        return this.mappedClass;
    }

    public void setMappedClass(Class<T> mappedClass) {
        if (this.mappedClass == null) {
            this.initialize(mappedClass);
        } else if (!this.mappedClass.equals(mappedClass)) {
            throw new InvalidDataAccessApiUsageException("The mapped class can not be reassigned to map to " + mappedClass + " since it is already providing mapping for " + this.mappedClass);
        }
    }

    public boolean isCheckFullyPopulated() {
        return this.checkFullyPopulated;
    }

    public void setCheckFullyPopulated(boolean checkFullyPopulated) {
        this.checkFullyPopulated = checkFullyPopulated;
    }

    public boolean isPrimitivesDefaultedForNullValue() {
        return this.primitivesDefaultedForNullValue;
    }

    public void setPrimitivesDefaultedForNullValue(boolean primitivesDefaultedForNullValue) {
        this.primitivesDefaultedForNullValue = primitivesDefaultedForNullValue;
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        bw.setConversionService((ConversionService)conversionService);
    }

    protected Object getColumnValue(ResultSet rs, int index, PropertyDescriptor pd) throws SQLException {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index, pd.getPropertyType());
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        Object mappedObject = BeanUtils.instantiate(this.mappedClass);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)mappedObject);
        this.initBeanWrapper(bw);
        HashSet<String> populatedProperties = this.isCheckFullyPopulated() ? new HashSet<String>() : null;
        for (int i = 0; i < aliases.length; ++i) {
            String column = aliases[i];
            PropertyDescriptor pd = this.mappedFields.get(column.replaceAll(" ", "").toLowerCase());
            if (pd == null) continue;
            try {
                Object value = tuple[i];
                try {
                    bw.setPropertyValue(pd.getName(), value);
                }
                catch (TypeMismatchException e) {
                    if (value == null && this.primitivesDefaultedForNullValue) {
                        this.logger.debug((Object)("Intercepted TypeMismatchException for column " + column + " and column '" + column + "' with value " + value + " when setting property '" + pd.getName() + "' of type " + pd.getPropertyType() + " on object: " + mappedObject));
                    }
                    throw e;
                }
                if (populatedProperties == null) continue;
                populatedProperties.add(pd.getName());
                continue;
            }
            catch (NotWritablePropertyException ex) {
                throw new DataRetrievalFailureException("Unable to map column " + column + " to property " + pd.getName(), (Throwable)ex);
            }
        }
        if (populatedProperties != null && !populatedProperties.equals(this.mappedProperties)) {
            throw new InvalidDataAccessApiUsageException("Given ResultSet does not contain all fields necessary to populate object of class [" + this.mappedClass + "]: " + this.mappedProperties);
        }
        return mappedObject;
    }

    public List transformList(List list) {
        return list;
    }

    static {
        Collection convertersToRegister = JodaTimeConverters.getConvertersToRegister();
        for (Converter converter : convertersToRegister) {
            conversionService.addConverter(converter);
        }
    }
}

