/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.QueryTemplate;
import com.slyak.spring.jpa.QueryTemplateContext;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.ReflectionUtils;

public class AbstractTemplateBasedJpaQuery
extends AbstractJpaQuery {
    private JpaQueryMethod method;
    private QueryTemplate query;
    private QueryTemplate countQuery;

    public AbstractTemplateBasedJpaQuery(JpaQueryMethod method, EntityManager em, QueryTemplateContext context) {
        super(method, em);
        this.method = method;
        this.query = context.lookup(this.getQueryMethod().getNamedQueryName());
        String cq = (String)this.executeMethod("getCountQuery");
        this.countQuery = cq == null ? null : context.lookup(cq);
    }

    protected Query doCreateQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.getQueryMethod().getParameters(), values);
        String sortedQueryString = QueryUtils.applySorting((String)this.query.getQueryString(), (Sort)accessor.getSort(), (String)QueryUtils.detectAlias((String)this.query.getQueryString()));
        Query query = this.createJpaQuery(sortedQueryString);
        return this.createBinder(values).bindAndPrepare(query);
    }

    protected Query doCreateCountQuery(Object[] values) {
        String queryString = this.countQuery.getQueryString();
        EntityManager em = this.getEntityManager();
        boolean isNativeQuery = (Boolean)this.executeMethod("nativeQuery");
        return this.createBinder(values).bind((Query)(isNativeQuery ? em.createNativeQuery(queryString) : em.createQuery(queryString, Long.class)));
    }

    public Query createJpaQuery(String queryString) {
        return this.getEntityManager().createQuery(queryString);
    }

    protected ParameterBinder createBinder(Object[] values) {
        return new TemplateQueryParameterBinder(this.getQueryMethod().getParameters(), values);
    }

    private <T> T executeMethod(String methodName) {
        Method countQueryMethod = ReflectionUtils.findMethod(JpaQueryMethod.class, (String)methodName);
        ReflectionUtils.makeAccessible((Method)countQueryMethod);
        return (T)ReflectionUtils.invokeMethod((Method)countQueryMethod, (Object)this.method);
    }

    private static class TemplateQueryParameterBinder
    extends ParameterBinder {
        private Object[] values;
        private JpaParameters parameters;

        public TemplateQueryParameterBinder(JpaParameters parameters, Object[] values) {
            super(parameters, values);
            this.values = values;
            this.parameters = parameters;
        }
    }
}

