/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.model.AclType;
import com.qiniu.storage.model.BucketInfo;
import com.qiniu.storage.model.FetchRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.storage.model.FileListing;
import com.qiniu.storage.model.IndexPageType;
import com.qiniu.storage.model.StorageType;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BucketManager {
    private final Auth auth;
    private Configuration configuration;
    private final Client client;

    public BucketManager(Auth auth, Configuration cfg) {
        this.auth = auth;
        this.configuration = cfg.clone();
        this.client = new Client(this.configuration);
    }

    public BucketManager(Auth auth, Client client) {
        this.auth = auth;
        this.client = client;
    }

    public static String encodedEntry(String bucket, String key) {
        String encodedEntry = key != null ? UrlSafeBase64.encodeToString(bucket + ":" + key) : UrlSafeBase64.encodeToString(bucket);
        return encodedEntry;
    }

    public static String encodedEntry(String bucket) {
        return BucketManager.encodedEntry(bucket, null);
    }

    public String[] buckets() throws QiniuException {
        String url = String.format("%s/buckets", this.configuration.rsHost());
        Response res = this.get(url);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        String[] buckets = res.jsonToObject(String[].class);
        res.close();
        return buckets;
    }

    public void createBucket(String bucketName, String region) throws QiniuException {
        String url = String.format("%s/mkbucketv2/%s/region/%s", this.configuration.rsHost(), UrlSafeBase64.encodeToString(bucketName), region);
        Response res = this.post(url, null);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        res.close();
    }

    public void deleteBucket(String bucketname) throws QiniuException {
        String url = String.format("%s/drop/%s", this.configuration.rsHost(), bucketname);
        Response res = this.post(url, null);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        res.close();
    }

    public String[] domainList(String bucket) throws QiniuException {
        String url = String.format("%s/v6/domain/list?tbl=%s", this.configuration.apiHost(), bucket);
        Response res = this.get(url);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        String[] domains = res.jsonToObject(String[].class);
        res.close();
        return domains;
    }

    public FileListIterator createFileListIterator(String bucket, String prefix) {
        return new FileListIterator(bucket, prefix, 1000, null);
    }

    public FileListIterator createFileListIterator(String bucket, String prefix, int limit, String delimiter) {
        return new FileListIterator(bucket, prefix, limit, delimiter);
    }

    private String listQuery(String bucket, String prefix, String marker, int limit, String delimiter) {
        StringMap map = new StringMap().put("bucket", bucket).putNotEmpty("marker", marker).putNotEmpty("prefix", prefix).putNotEmpty("delimiter", delimiter).putWhen("limit", limit, limit > 0);
        return map.formString();
    }

    public Response listV1(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        String url = String.format("%s/list?%s", this.configuration.rsfHost(this.auth.accessKey, bucket), this.listQuery(bucket, prefix, marker, limit, delimiter));
        return this.get(url);
    }

    public FileListing listFiles(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        Response response = this.listV1(bucket, prefix, marker, limit, delimiter);
        if (!response.isOK()) {
            throw new QiniuException(response);
        }
        FileListing fileListing = response.jsonToObject(FileListing.class);
        response.close();
        return fileListing;
    }

    public Response listV2(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        String url = String.format("%s/v2/list?%s", this.configuration.rsfHost(this.auth.accessKey, bucket), this.listQuery(bucket, prefix, marker, limit, delimiter));
        return this.get(url);
    }

    public FileListing listFilesV2(String bucket, String prefix, String marker, int limit, String delimiter) throws QiniuException {
        Response response = this.listV2(bucket, prefix, marker, limit, delimiter);
        String result = response.bodyString();
        response.close();
        List<String> lineList = Arrays.asList(result.split("\n"));
        FileListing fileListing = new FileListing();
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        HashSet<String> commonPrefixSet = new HashSet<String>();
        for (int i = 0; i < lineList.size(); ++i) {
            String dir;
            String line = lineList.get(i);
            JsonObject jsonObject = Json.decode(line, JsonObject.class);
            if (!(jsonObject.get("item") instanceof JsonNull)) {
                fileInfoList.add(Json.decode(jsonObject.get("item"), FileInfo.class));
            }
            if (!"".equals(dir = jsonObject.get("dir").getAsString())) {
                commonPrefixSet.add(dir);
            }
            if (i != lineList.size() - 1) continue;
            fileListing.marker = jsonObject.get("marker").getAsString();
        }
        fileListing.items = fileInfoList.toArray(new FileInfo[0]);
        fileListing.commonPrefixes = commonPrefixSet.toArray(new String[0]);
        return fileListing;
    }

    public FileInfo stat(String bucket, String fileKey) throws QiniuException {
        Response res = this.rsGet(bucket, String.format("/stat/%s", BucketManager.encodedEntry(bucket, fileKey)));
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        FileInfo fileInfo = res.jsonToObject(FileInfo.class);
        res.close();
        return fileInfo;
    }

    public Response delete(String bucket, String key) throws QiniuException {
        return this.rsPost(bucket, String.format("/delete/%s", BucketManager.encodedEntry(bucket, key)), null);
    }

    public Response changeMime(String bucket, String key, String mime) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String encodedMime = UrlSafeBase64.encodeToString(mime);
        String path = String.format("/chgm/%s/mime/%s", resource, encodedMime);
        return this.rsPost(bucket, path, null);
    }

    public Response changeHeaders(String bucket, String key, Map<String, String> headers) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/chgm/%s", resource);
        for (String k : headers.keySet()) {
            String encodedMetaValue = UrlSafeBase64.encodeToString(headers.get(k));
            path = String.format("%s/x-qn-meta-!%s/%s", path, k, encodedMetaValue);
        }
        return this.rsPost(bucket, path, null);
    }

    public Response changeType(String bucket, String key, StorageType type) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/chtype/%s/type/%d", resource, type.ordinal());
        return this.rsPost(bucket, path, null);
    }

    public Response changeStatus(String bucket, String key, int status) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/chstatus/%s/status/%d", resource, status);
        return this.rsPost(bucket, path, null);
    }

    public Response rename(String bucket, String oldFileKey, String newFileKey, boolean force) throws QiniuException {
        return this.move(bucket, oldFileKey, bucket, newFileKey, force);
    }

    public Response rename(String bucket, String oldFileKey, String newFileKey) throws QiniuException {
        return this.move(bucket, oldFileKey, bucket, newFileKey);
    }

    public Response copy(String fromBucket, String fromFileKey, String toBucket, String toFileKey, boolean force) throws QiniuException {
        String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
        String to = BucketManager.encodedEntry(toBucket, toFileKey);
        String path = String.format("/copy/%s/%s/force/%s", from, to, force);
        return this.rsPost(fromBucket, path, null);
    }

    public void copy(String fromBucket, String fromFileKey, String toBucket, String toFileKey) throws QiniuException {
        Response res = this.copy(fromBucket, fromFileKey, toBucket, toFileKey, false);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        res.close();
    }

    public Response move(String fromBucket, String fromFileKey, String toBucket, String toFileKey, boolean force) throws QiniuException {
        String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
        String to = BucketManager.encodedEntry(toBucket, toFileKey);
        String path = String.format("/move/%s/%s/force/%s", from, to, force);
        return this.rsPost(fromBucket, path, null);
    }

    public Response move(String fromBucket, String fromFileKey, String toBucket, String toFileKey) throws QiniuException {
        return this.move(fromBucket, fromFileKey, toBucket, toFileKey, false);
    }

    public FetchRet fetch(String url, String bucket) throws QiniuException {
        return this.fetch(url, bucket, null);
    }

    public FetchRet fetch(String url, String bucket, String key) throws QiniuException {
        String resource = UrlSafeBase64.encodeToString(url);
        String to = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/fetch/%s/to/%s", resource, to);
        Response res = this.ioPost(bucket, path);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        FetchRet fetchRet = res.jsonToObject(FetchRet.class);
        res.close();
        return fetchRet;
    }

    public Response asynFetch(String url, String bucket, String key) throws QiniuException {
        String requesturl = this.configuration.apiHost(this.auth.accessKey, bucket) + "/sisyphus/fetch";
        StringMap stringMap = new StringMap().put("url", url).put("bucket", bucket).putNotNull("key", key);
        byte[] bodyByte = Json.encode(stringMap).getBytes(Constants.UTF_8);
        return this.client.post(requesturl, bodyByte, this.auth.authorizationV2(requesturl, "POST", bodyByte, "application/json"), "application/json");
    }

    public Response asynFetch(String url, String bucket, String key, String md5, String etag, String callbackurl, String callbackbody, String callbackbodytype, String callbackhost, String fileType) throws QiniuException {
        String requesturl = this.configuration.apiHost(this.auth.accessKey, bucket) + "/sisyphus/fetch";
        StringMap stringMap = new StringMap().put("url", url).put("bucket", bucket).putNotNull("key", key).putNotNull("md5", md5).putNotNull("etag", etag).putNotNull("callbackurl", callbackurl).putNotNull("callbackbody", callbackbody).putNotNull("callbackbodytype", callbackbodytype).putNotNull("callbackhost", callbackhost).putNotNull("file_type", fileType);
        byte[] bodyByte = Json.encode(stringMap).getBytes(Constants.UTF_8);
        return this.client.post(requesturl, bodyByte, this.auth.authorizationV2(requesturl, "POST", bodyByte, "application/json"), "application/json");
    }

    public Response checkAsynFetchid(String region, String fetchWorkId) throws QiniuException {
        String path = String.format("http://api-%s.qiniu.com/sisyphus/fetch?id=%s", region, fetchWorkId);
        return this.client.get(path, this.auth.authorization(path));
    }

    public void prefetch(String bucket, String key) throws QiniuException {
        String resource = BucketManager.encodedEntry(bucket, key);
        String path = String.format("/prefetch/%s", resource);
        Response res = this.ioPost(bucket, path);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        res.close();
    }

    public Response setImage(String bucket, String srcSiteUrl) throws QiniuException {
        return this.setImage(bucket, srcSiteUrl, null);
    }

    public Response setImage(String bucket, String srcSiteUrl, String host) throws QiniuException {
        String encodedSiteUrl = UrlSafeBase64.encodeToString(srcSiteUrl);
        String encodedHost = null;
        if (host != null && host.length() > 0) {
            encodedHost = UrlSafeBase64.encodeToString(host);
        }
        String path = String.format("/image/%s/from/%s", bucket, encodedSiteUrl);
        if (encodedHost != null) {
            path = path + String.format("/host/%s", encodedHost);
        }
        return this.pubPost(path);
    }

    public Response unsetImage(String bucket) throws QiniuException {
        String path = String.format("/unimage/%s", bucket);
        return this.pubPost(path);
    }

    public Response deleteAfterDays(String bucket, String key, int days) throws QiniuException {
        return this.rsPost(bucket, String.format("/deleteAfterDays/%s/%d", BucketManager.encodedEntry(bucket, key), days), null);
    }

    public void setBucketAcl(String bucket, AclType acl) throws QiniuException {
        String url = String.format("%s/private?bucket=%s&private=%s", this.configuration.ucHost(), bucket, acl.getType());
        Response res = this.post(url, null);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        res.close();
    }

    public BucketInfo getBucketInfo(String bucket) throws QiniuException {
        String url = String.format("%s/v2/bucketInfo?bucket=%s", this.configuration.ucHost(), bucket);
        Response res = this.post(url, null);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        BucketInfo info = res.jsonToObject(BucketInfo.class);
        res.close();
        return info;
    }

    public void setIndexPage(String bucket, IndexPageType type) throws QiniuException {
        String url = String.format("%s/noIndexPage?bucket=%s&noIndexPage=%s", this.configuration.ucHost(), bucket, type.getType());
        Response res = this.post(url, null);
        if (!res.isOK()) {
            throw new QiniuException(res);
        }
        res.close();
    }

    private Response rsPost(String bucket, String path, byte[] body) throws QiniuException {
        this.check(bucket);
        String url = this.configuration.rsHost(this.auth.accessKey, bucket) + path;
        return this.post(url, body);
    }

    private Response rsGet(String bucket, String path) throws QiniuException {
        this.check(bucket);
        String url = this.configuration.rsHost(this.auth.accessKey, bucket) + path;
        return this.get(url);
    }

    private Response ioPost(String bucket, String path) throws QiniuException {
        this.check(bucket);
        String url = this.configuration.ioHost(this.auth.accessKey, bucket) + path;
        return this.post(url, null);
    }

    private Response pubPost(String path) throws QiniuException {
        String url = "http://pu.qbox.me:10200" + path;
        return this.post(url, null);
    }

    private Response get(String url) throws QiniuException {
        StringMap headers = this.auth.authorization(url);
        return this.client.get(url, headers);
    }

    private Response post(String url, byte[] body) throws QiniuException {
        StringMap headers = this.auth.authorization(url, body, "application/x-www-form-urlencoded");
        return this.client.post(url, body, headers, "application/x-www-form-urlencoded");
    }

    private void check(String bucket) throws QiniuException {
        if (StringUtils.isNullOrEmpty(bucket)) {
            throw new QiniuException(Response.createError(null, null, 0.0, "\u672a\u6307\u5b9a\u64cd\u4f5c\u7684\u7a7a\u95f4\u6216\u64cd\u4f5c\u4f53\u4e3a\u7a7a"));
        }
    }

    public Response batch(BatchOperations operations) throws QiniuException {
        return this.rsPost(operations.execBucket(), "/batch", operations.toBody());
    }

    public class FileListIterator
    implements Iterator<FileInfo[]> {
        private String marker = null;
        private String bucket;
        private String delimiter;
        private int limit;
        private String prefix;
        private QiniuException exception = null;

        public FileListIterator(String bucket, String prefix, int limit, String delimiter) {
            if (limit <= 0) {
                throw new IllegalArgumentException("limit must greater than 0");
            }
            if (limit > 1000) {
                throw new IllegalArgumentException("limit must not greater than 1000");
            }
            this.bucket = bucket;
            this.prefix = prefix;
            this.limit = limit;
            this.delimiter = delimiter;
        }

        public QiniuException error() {
            return this.exception;
        }

        @Override
        public boolean hasNext() {
            return this.exception == null && !"".equals(this.marker);
        }

        @Override
        public FileInfo[] next() {
            try {
                FileListing f = BucketManager.this.listFiles(this.bucket, this.prefix, this.marker, this.limit, this.delimiter);
                this.marker = f.marker == null ? "" : f.marker;
                return f.items;
            }
            catch (QiniuException e) {
                this.exception = e;
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class BatchOperations {
        private ArrayList<String> ops = new ArrayList();
        private String execBucket = null;

        public BatchOperations addChgmOp(String bucket, String key, String newMimeType) {
            String resource = BucketManager.encodedEntry(bucket, key);
            String encodedMime = UrlSafeBase64.encodeToString(newMimeType);
            this.ops.add(String.format("/chgm/%s/mime/%s", resource, encodedMime));
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addCopyOp(String fromBucket, String fromFileKey, String toBucket, String toFileKey) {
            String from = BucketManager.encodedEntry(fromBucket, fromFileKey);
            String to = BucketManager.encodedEntry(toBucket, toFileKey);
            this.ops.add(String.format("copy/%s/%s", from, to));
            this.setExecBucket(fromBucket);
            return this;
        }

        public BatchOperations addRenameOp(String fromBucket, String fromFileKey, String toFileKey) {
            return this.addMoveOp(fromBucket, fromFileKey, fromBucket, toFileKey);
        }

        public BatchOperations addMoveOp(String fromBucket, String fromKey, String toBucket, String toKey) {
            String from = BucketManager.encodedEntry(fromBucket, fromKey);
            String to = BucketManager.encodedEntry(toBucket, toKey);
            this.ops.add(String.format("move/%s/%s", from, to));
            this.setExecBucket(fromBucket);
            return this;
        }

        public BatchOperations addDeleteOp(String bucket, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("delete/%s", BucketManager.encodedEntry(bucket, key)));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addStatOps(String bucket, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("stat/%s", BucketManager.encodedEntry(bucket, key)));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addChangeTypeOps(String bucket, StorageType type, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("chtype/%s/type/%d", BucketManager.encodedEntry(bucket, key), type.ordinal()));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addChangeStatusOps(String bucket, int status, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("chstatus/%s/status/%d", BucketManager.encodedEntry(bucket, key), status));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public BatchOperations addDeleteAfterDaysOps(String bucket, int days, String ... keys) {
            for (String key : keys) {
                this.ops.add(String.format("deleteAfterDays/%s/%d", BucketManager.encodedEntry(bucket, key), days));
            }
            this.setExecBucket(bucket);
            return this;
        }

        public byte[] toBody() {
            String body = StringUtils.join(this.ops, "&op=", "op=");
            return StringUtils.utf8Bytes(body);
        }

        public BatchOperations merge(BatchOperations batch) {
            this.ops.addAll(batch.ops);
            this.setExecBucket(batch.execBucket());
            return this;
        }

        public BatchOperations clearOps() {
            this.ops.clear();
            return this;
        }

        private void setExecBucket(String bucket) {
            if (this.execBucket == null) {
                this.execBucket = bucket;
            }
        }

        public String execBucket() {
            return this.execBucket;
        }
    }
}

