/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.sign;

import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;

public class FileCloudSign {
    public static String appSign(int appId, String secret_id, String secret_key, long expired) {
        return FileCloudSign.appSignBase(appId, secret_id, secret_key, "", expired, "");
    }

    public static String appSignV2(int appId, String secret_id, String secret_key, String bucket, long expired) {
        return FileCloudSign.appSignBase(appId, secret_id, secret_key, bucket, expired, "");
    }

    public static String appSignOnce(int appId, String secret_id, String secret_key, String fileid) {
        return FileCloudSign.appSignBase(appId, secret_id, secret_key, "", 0L, fileid);
    }

    public static String appSignOnceV2(int appId, String secret_id, String secret_key, String bucket, String fileid) {
        return FileCloudSign.appSignBase(appId, secret_id, secret_key, bucket, 0L, fileid);
    }

    private static String appSignBase(int appId, String secret_id, String secret_key, String bucket, long expired, String fileid) {
        if (FileCloudSign.empty(secret_id) || FileCloudSign.empty(secret_key)) {
            return null;
        }
        long now = System.currentTimeMillis() / 1000L;
        int rdm = Math.abs(new Random().nextInt());
        String plain_text = "";
        plain_text = FileCloudSign.empty(bucket) ? String.format("a=%d&k=%s&e=%d&t=%d&r=%d&u=%s&f=%s", appId, secret_id, expired, now, rdm, 0, fileid) : String.format("a=%d&b=%s&k=%s&e=%d&t=%d&r=%d&u=%s&f=%s", appId, bucket, secret_id, expired, now, rdm, 0, fileid);
        byte[] bin = HmacUtils.hmacSha1((String)secret_key, (String)plain_text);
        byte[] all = new byte[bin.length + plain_text.getBytes().length];
        System.arraycopy(bin, 0, all, 0, bin.length);
        System.arraycopy(plain_text.getBytes(), 0, all, bin.length, plain_text.getBytes().length);
        all = Base64.encodeBase64((byte[])all);
        return new String(all);
    }

    public static boolean empty(String s) {
        return s == null || s.trim().equals("") || s.trim().equals("null");
    }
}

