/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud;

import com.qcloud.CloudClient;
import com.qcloud.PicAnalyze;
import com.qcloud.PicInfo;
import com.qcloud.PornDetectInfo;
import com.qcloud.SliceUploadInfo;
import com.qcloud.UploadResult;
import com.qcloud.sign.FileCloudSign;
import com.qcloud.sign.PicProcessSign;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PicCloud {
    protected static String VERSION = "2.1.4";
    protected static String QCLOUD_DOMAIN = "image.myqcloud.com";
    protected static String PROCESS_DOMAIN = "service.image.myqcloud.com";
    protected int mAppId;
    protected String mSecretId;
    protected String mSecretKey;
    protected String mBucket;
    protected int mErrno;
    protected String mError;
    protected String mMagicContect;
    protected CloudClient mClient;

    public PicCloud(int appId, String secretId, String secretKey) {
        this.mAppId = appId;
        this.mSecretId = secretId;
        this.mSecretKey = secretKey;
        this.mErrno = 0;
        this.mBucket = "";
        this.mError = "";
        this.mClient = new CloudClient();
    }

    public PicCloud(int appId, String secret_id, String secret_key, String bucket) {
        this.mAppId = appId;
        this.mSecretId = secret_id;
        this.mSecretKey = secret_key;
        this.mBucket = bucket;
        this.mErrno = 0;
        this.mError = "";
        this.mClient = new CloudClient();
    }

    public String getVersion() {
        return VERSION;
    }

    public int getErrno() {
        return this.mErrno;
    }

    public String getErrMsg() {
        return this.mError;
    }

    public int setError(int errno, String msg) {
        this.mErrno = errno;
        this.mError = msg;
        return errno;
    }

    public String getError() {
        return "errno=" + this.mErrno + " desc=" + this.mError;
    }

    public void setMagicContext(String context) {
        this.mMagicContect = context;
    }

    public String getMagicContext() {
        return this.mMagicContect;
    }

    public String getUrl(String userid, String fileId) {
        String url = "".equals(this.mBucket) ? String.format("http://web.%s/photos/v1/%d/%s", QCLOUD_DOMAIN, this.mAppId, userid) : String.format("http://web.%s/photos/v2/%d/%s/%s", QCLOUD_DOMAIN, this.mAppId, this.mBucket, userid);
        if (!"".equals(fileId)) {
            String params = fileId;
            try {
                params = URLEncoder.encode(fileId, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                System.out.printf("url encode failed, fileId=%s", fileId);
            }
            url = url + "/" + params;
        }
        return url;
    }

    public String getDownloadUrl(String userid, String fileId) {
        String url = "".equals(this.mBucket) ? String.format("http://%d.%s/%d/%s/%s/original", this.mAppId, QCLOUD_DOMAIN, this.mAppId, userid, fileId) : String.format("http://%s-%d.%s/%s-%d/%s/%s/original", this.mBucket, this.mAppId, QCLOUD_DOMAIN, this.mBucket, this.mAppId, userid, fileId);
        return url;
    }

    public JSONObject getResponse(String rsp) {
        if ("".equals(rsp)) {
            this.setError(-1, "empty rsp");
            return null;
        }
        JSONObject pack = new JSONObject(rsp);
        int code = pack.getInt("code");
        String msg = pack.getString("message");
        if (code != 0) {
            this.setError(code, msg);
            return null;
        }
        return pack;
    }

    public UploadResult upload(String fileName) {
        return this.upload(fileName, "", new PicAnalyze());
    }

    public UploadResult upload(String fileName, String fileId) {
        return this.upload(fileName, fileId, new PicAnalyze());
    }

    public UploadResult upload(String fileName, String fileId, PicAnalyze flag) {
        if ("".equals(fileName)) {
            this.setError(-1, "invalid file name");
            return null;
        }
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException ex) {
            this.setError(-1, "invalid file name");
            return null;
        }
        return this.upload(fileStream, fileId, flag);
    }

    public UploadResult upload(InputStream inputStream) {
        return this.upload(inputStream, "", new PicAnalyze());
    }

    public UploadResult upload(InputStream inputStream, String fileId) {
        return this.upload(inputStream, fileId, new PicAnalyze());
    }

    public UploadResult upload(InputStream inputStream, String fileId, PicAnalyze flag) {
        long expired;
        String sign;
        String url = this.getUrl("0", fileId);
        String queryString = "";
        if (flag.fuzzy != 0) {
            queryString = queryString + ".fuzzy";
        }
        if (flag.food != 0) {
            queryString = queryString + ".food";
        }
        if (!"".equals(queryString)) {
            url = url + "?analyze=" + queryString.substring(1);
        }
        if (null == (sign = this.getSign(expired = System.currentTimeMillis() / 1000L + 2592000L))) {
            this.setError(-1, "create app sign failed");
            return null;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", sign);
        header.put("Host", "web.image.myqcloud.com");
        HashMap<String, Object> body = new HashMap<String, Object>();
        JSONObject rspData = null;
        try {
            byte[] data = new byte[inputStream.available()];
            inputStream.read(data);
            String rsp = this.mClient.post(url, header, body, data);
            rspData = this.getResponse(rsp);
            if (null == rspData || !rspData.has("data")) {
                this.setError(-1, "qcloud api response error, rsp=" + rsp);
                return null;
            }
            rspData = rspData.getJSONObject("data");
        }
        catch (Exception e) {
            this.setError(-1, "url exception, e=" + e.toString());
            return null;
        }
        UploadResult info = new UploadResult();
        try {
            info.url = rspData.getString("url");
            info.downloadUrl = rspData.getString("download_url");
            info.fileId = rspData.getString("fileid");
            if (rspData.has("info") && rspData.getJSONArray("info").length() > 0) {
                info.width = rspData.getJSONArray("info").getJSONObject(0).getJSONObject("0").getInt("width");
                info.height = rspData.getJSONArray("info").getJSONObject(0).getJSONObject("0").getInt("height");
            }
            if (rspData.has("is_fuzzy")) {
                info.analyze.fuzzy = rspData.getInt("is_fuzzy");
            }
            if (rspData.has("is_food")) {
                info.analyze.food = rspData.getInt("is_food");
            }
        }
        catch (JSONException e) {
            this.setError(-1, "json exception, e=" + e.toString());
            return null;
        }
        this.setError(0, "success");
        return info;
    }

    public SliceUploadInfo simpleUploadSlice(String fileName) {
        return this.simpleUploadSlice(fileName, "", 0);
    }

    public SliceUploadInfo simpleUploadSlice(String fileName, int sliceSize) {
        return this.simpleUploadSlice(fileName, "", sliceSize);
    }

    public SliceUploadInfo simpleUploadSlice(String fileName, String fileId, int sliceSize) {
        int fileSize = 0;
        byte[] data = null;
        try {
            FileInputStream fs = new FileInputStream(fileName);
            fileSize = fs.available();
            data = new byte[fileSize];
            fs.read(data);
            fs.close();
        }
        catch (Exception e) {
            this.setError(-1, "read file failed");
            return null;
        }
        SliceUploadInfo info = this.initUploadSlice(fileId, data, fileSize, sliceSize);
        if (null == info) {
            return info;
        }
        while (!info.finishFlag) {
            SliceUploadInfo newInfo = this.UploadSlice(data, info);
            if (newInfo == null) {
                this.setError(-1, "slice upload failed, need retry");
                return null;
            }
            info = newInfo;
        }
        this.setError(0, "success");
        return info;
    }

    public SliceUploadInfo simpleUploadSlice(String fileName, SliceUploadInfo lastInfo) {
        byte[] data = null;
        try {
            FileInputStream fs = new FileInputStream(fileName);
            data = new byte[fs.available()];
            fs.read(data);
            fs.close();
        }
        catch (Exception e) {
            this.setError(-1, "read file failed");
            return null;
        }
        SliceUploadInfo info = this.initUploadSlice(lastInfo.fileId, data, lastInfo.fileSize, lastInfo.sliceSize, lastInfo.session);
        if (null == info) {
            return info;
        }
        int maxRetry = 3;
        while (!info.finishFlag) {
            int retry;
            for (retry = 0; retry < maxRetry; ++retry) {
                SliceUploadInfo newInfo = this.UploadSlice(data, info);
                if (newInfo == null) continue;
                info = newInfo;
                break;
            }
            if (retry < maxRetry) continue;
            this.setError(-1, "slice upload failed, need retry");
            return null;
        }
        this.setError(0, "success");
        return info;
    }

    public SliceUploadInfo initUploadSlice(String fileId, byte[] data, int fileSize, int sliceSize) {
        return this.initUploadSlice(fileId, data, fileSize, sliceSize, "");
    }

    public SliceUploadInfo initUploadSlice(String fileId, byte[] data, int fileSize, int sliceSize, String session) {
        SliceUploadInfo info;
        block11: {
            info = new SliceUploadInfo();
            String sha = DigestUtils.sha1Hex((byte[])data);
            long expired = System.currentTimeMillis() / 1000L + 2592000L;
            String sign = this.getSign(expired);
            if (null == sign) {
                this.setError(-1, "create app sign failed");
                return null;
            }
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", sign);
            header.put("Host", "web.image.myqcloud.com");
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("op", "upload_slice");
            body.put("sha", sha);
            body.put("filesize", fileSize);
            if (sliceSize > 0) {
                body.put("slice_size", sliceSize);
            }
            if ("".equals(session)) {
                body.put("session", session);
            }
            String url = this.getUrl("0", fileId);
            JSONObject rspData = null;
            try {
                String rsp = this.mClient.post(url, header, body, null);
                rspData = this.getResponse(rsp);
                if (null == rspData || !rspData.has("data")) {
                    this.setError(-1, "qcloud api response error, rsp=" + rsp);
                    return null;
                }
                rspData = rspData.getJSONObject("data");
            }
            catch (Exception e) {
                this.setError(-1, "url exception, e=" + e.toString());
                return null;
            }
            try {
                if (rspData.has("url")) {
                    info.finishFlag = true;
                    info.url = rspData.getString("url");
                    info.downloadUrl = rspData.getString("download_url");
                    info.fileId = rspData.getString("fileid");
                    if (rspData.has("info") && rspData.getJSONArray("info").length() > 0) {
                        info.width = rspData.getJSONArray("info").getJSONObject(0).getJSONObject("0").getInt("width");
                        info.height = rspData.getJSONArray("info").getJSONObject(0).getJSONObject("0").getInt("height");
                    }
                    break block11;
                }
                if (rspData.has("session")) {
                    info.finishFlag = false;
                    info.reqUrl = url;
                    info.sign = sign;
                    info.session = rspData.getString("session");
                    info.fileSize = fileSize;
                    info.offset = rspData.getInt("offset");
                    info.sliceSize = rspData.getInt("slice_size");
                    break block11;
                }
                this.setError(-1, "qcloud api response data error");
                return null;
            }
            catch (JSONException e) {
                this.setError(-1, "json exception, e=" + e.toString());
                return null;
            }
        }
        return info;
    }

    public SliceUploadInfo UploadSlice(byte[] data, SliceUploadInfo info) {
        SliceUploadInfo newInfo;
        block9: {
            if (info.finishFlag) {
                this.setError(0, "success");
                return info;
            }
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", info.sign);
            header.put("Host", "web.image.myqcloud.com");
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("op", "upload_slice");
            body.put("session", info.session);
            body.put("offset", info.offset);
            JSONObject rspData = null;
            try {
                int from = info.offset;
                int to = info.offset + info.sliceSize;
                to = to > info.fileSize ? info.fileSize : to;
                byte[] sliceData = Arrays.copyOfRange(data, from, to);
                String rsp = this.mClient.post(info.reqUrl, header, body, sliceData);
                rspData = this.getResponse(rsp);
                if (null == rspData || !rspData.has("data")) {
                    this.setError(-1, "qcloud api response error, rsp=" + rsp);
                    return null;
                }
                rspData = rspData.getJSONObject("data");
            }
            catch (Exception e) {
                this.setError(-1, "url exception, e=" + e.toString());
                return null;
            }
            newInfo = new SliceUploadInfo();
            try {
                if (rspData.has("url")) {
                    newInfo.finishFlag = true;
                    newInfo.url = rspData.getString("url");
                    newInfo.downloadUrl = rspData.getString("download_url");
                    newInfo.fileId = rspData.getString("fileid");
                    if (rspData.has("info") && rspData.getJSONArray("info").length() > 0) {
                        newInfo.width = rspData.getJSONArray("info").getJSONObject(0).getJSONObject("0").getInt("width");
                        newInfo.height = rspData.getJSONArray("info").getJSONObject(0).getJSONObject("0").getInt("height");
                    }
                    break block9;
                }
                if (rspData.has("session")) {
                    newInfo.finishFlag = false;
                    newInfo.reqUrl = info.reqUrl;
                    newInfo.sign = info.sign;
                    newInfo.session = rspData.getString("session");
                    newInfo.offset = rspData.getInt("offset") + info.sliceSize;
                    newInfo.sliceSize = info.sliceSize;
                    newInfo.fileSize = info.fileSize;
                    break block9;
                }
                this.setError(-1, "qcloud api response data error");
                return null;
            }
            catch (JSONException e) {
                this.setError(-1, "json exception, e=" + e.toString());
                return null;
            }
        }
        this.setError(0, "success");
        return newInfo;
    }

    public int delete(String fileId) {
        String sign = this.getSignOnce(fileId);
        if (null == sign) {
            return this.setError(-1, "create app sign failed");
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", sign);
        header.put("Host", "web.image.myqcloud.com");
        String url = this.getUrl("0", fileId) + "/del";
        try {
            String rsp = this.mClient.post(url, header, null, null);
            JSONObject rspData = this.getResponse(rsp);
            if (null == rspData) {
                return this.setError(-1, "qcloud api response packet error, rsp=" + rsp);
            }
        }
        catch (Exception e) {
            return this.setError(-1, "url exception, e=" + e.toString());
        }
        return this.setError(0, "success");
    }

    public PicInfo stat(String fileId) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "web.image.myqcloud.com");
        String url = this.getUrl("0", fileId);
        JSONObject rspData = null;
        try {
            String rsp = this.mClient.get(url, header, null);
            rspData = this.getResponse(rsp);
            if (null == rspData || !rspData.has("data")) {
                this.setError(-1, "qcloud api response error, rsp=" + rsp);
                return null;
            }
            rspData = rspData.getJSONObject("data");
        }
        catch (Exception e) {
            this.setError(-1, "url exception, e=" + e.toString());
            return null;
        }
        PicInfo info = new PicInfo();
        try {
            info.url = rspData.getString("file_url");
            info.fileId = rspData.getString("file_fileid");
            info.uploadTime = rspData.getInt("file_upload_time");
            info.size = rspData.getInt("file_size");
            info.md5 = rspData.getString("file_md5");
            info.width = rspData.getInt("photo_width");
            info.height = rspData.getInt("photo_height");
        }
        catch (JSONException e) {
            this.setError(-1, "json exception, e=" + e.toString());
            return null;
        }
        this.setError(0, "success");
        return info;
    }

    public UploadResult copy(String fileId) {
        String sign = this.getSignOnce(fileId);
        if (null == sign) {
            this.setError(-1, "create app sign failed");
            return null;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", sign);
        header.put("Host", "web.image.myqcloud.com");
        String url = this.getUrl("0", fileId) + "/copy";
        JSONObject rspData = null;
        try {
            String rsp = this.mClient.post(url, header, null, null);
            rspData = this.getResponse(rsp);
            if (null == rspData || !rspData.has("data")) {
                this.setError(-1, "qcloud api response error, rsp=" + rsp);
                return null;
            }
            rspData = rspData.getJSONObject("data");
        }
        catch (Exception e) {
            this.setError(-1, "url exception, e=" + e.toString());
            return null;
        }
        UploadResult info = new UploadResult();
        try {
            info.url = rspData.getString("url");
            info.downloadUrl = rspData.getString("download_url");
            info.fileId = info.url.substring(info.url.lastIndexOf(47) + 1);
            if (rspData.has("info") && rspData.getJSONArray("info").length() > 0) {
                info.width = rspData.getJSONArray("info").getJSONObject(0).getJSONObject("0").getInt("width");
                info.height = rspData.getJSONArray("info").getJSONObject(0).getJSONObject("0").getInt("height");
            }
        }
        catch (JSONException e) {
            this.setError(-1, "json exception, e=" + e.toString());
            return null;
        }
        this.setError(0, "success");
        return info;
    }

    public int download(String url, String fileName) {
        Object rspData = null;
        try {
            String rsp = this.mClient.get(url, null, null);
            File file = new File(fileName);
            DataOutputStream ops = new DataOutputStream(new FileOutputStream(file));
            ops.writeBytes(rsp);
            ops.close();
        }
        catch (Exception e) {
            return this.setError(-1, "url exception, e=" + e.toString());
        }
        return this.setError(0, "success");
    }

    public String getSign(long expired) {
        return FileCloudSign.appSignV2(this.mAppId, this.mSecretId, this.mSecretKey, this.mBucket, expired);
    }

    public String getSignOnce(String fileId) {
        return FileCloudSign.appSignOnceV2(this.mAppId, this.mSecretId, this.mSecretKey, this.mBucket, fileId);
    }

    public String getProcessSign(long expired, String url) {
        return PicProcessSign.sign(this.mAppId, this.mSecretId, this.mSecretKey, this.mBucket, expired, url);
    }

    public PornDetectInfo pornDetect(String url) {
        long expired = System.currentTimeMillis() / 1000L + 86400L;
        String sign = this.getProcessSign(expired, url);
        if (null == sign) {
            this.setError(-1, "create app sign failed");
            return null;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", sign);
        header.put("Host", PROCESS_DOMAIN);
        header.put("Content-Type", "application/json");
        JSONObject reqData = new JSONObject();
        reqData.put("appid", this.mAppId);
        reqData.put("bucket", (Object)this.mBucket);
        reqData.put("url", (Object)url);
        String reqUrl = "http://" + PROCESS_DOMAIN + "/detection/pornDetect";
        JSONObject rspData = null;
        try {
            String rsp = this.mClient.post(reqUrl, header, null, reqData.toString().getBytes());
            rspData = this.getResponse(rsp);
            if (null == rspData || !rspData.has("data")) {
                this.setError(-1, "qcloud api response error");
                return null;
            }
            rspData = rspData.getJSONObject("data");
        }
        catch (Exception e) {
            this.setError(-1, "url exception, e=" + e.toString());
            return null;
        }
        PornDetectInfo info = new PornDetectInfo();
        try {
            info.result = rspData.getInt("result");
            info.confidence = rspData.getDouble("confidence");
            info.pornScore = rspData.getDouble("porn_score");
            info.normalScore = rspData.getDouble("normal_score");
            info.hotScore = rspData.getDouble("hot_score");
        }
        catch (JSONException e) {
            this.setError(-1, "json exception, e=" + e.toString());
            return null;
        }
        this.setError(0, "success");
        return info;
    }
}

