/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.transfer.CompleteMultipartUpload;
import com.qcloud.cos.transfer.PauseResult;
import com.qcloud.cos.transfer.PauseStatus;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerUtils;
import com.qcloud.cos.transfer.TransferMonitor;
import com.qcloud.cos.transfer.UploadCallable;
import com.qcloud.cos.transfer.UploadImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class UploadMonitor
implements Callable<UploadResult>,
TransferMonitor {
    private final COS cos;
    private final PutObjectRequest origReq;
    private final ProgressListenerChain listener;
    private final UploadCallable multipartUploadCallable;
    private final UploadImpl transfer;
    private final ExecutorService threadPool;
    private final List<Future<PartETag>> futures = Collections.synchronizedList(new ArrayList());
    private boolean isUploadDone = false;
    private AtomicReference<Future<UploadResult>> futureReference = new AtomicReference<Object>(null);

    public Future<UploadResult> getFuture() {
        return this.futureReference.get();
    }

    private synchronized void cancelFuture() {
        this.futureReference.get().cancel(true);
    }

    @Override
    public synchronized boolean isDone() {
        return this.isUploadDone;
    }

    private synchronized void markAllDone() {
        this.isUploadDone = true;
    }

    public static UploadMonitor create(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        UploadMonitor uploadMonitor = new UploadMonitor(manager, transfer, threadPool, multipartUploadCallable, putObjectRequest, progressListenerChain);
        uploadMonitor.futureReference.compareAndSet(null, threadPool.submit(uploadMonitor));
        return uploadMonitor;
    }

    private UploadMonitor(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.cos = manager.getCOSClient();
        this.multipartUploadCallable = multipartUploadCallable;
        this.origReq = putObjectRequest;
        this.listener = progressListenerChain;
        this.transfer = transfer;
        this.threadPool = threadPool;
    }

    @Override
    public UploadResult call() throws Exception {
        try {
            UploadResult result = this.multipartUploadCallable.call();
            if (result == null) {
                this.futures.addAll(this.multipartUploadCallable.getFutures());
                this.futureReference.set(this.threadPool.submit(new CompleteMultipartUpload(this.multipartUploadCallable.getMultipartUploadId(), this.cos, this.origReq, this.futures, this.multipartUploadCallable.getETags(), this.listener, this)));
                PersistableUpload persistableUploadInfo = this.multipartUploadCallable.getPersistableUpload();
                if (persistableUploadInfo != null) {
                    this.transfer.setPersistableUploadInfo(persistableUploadInfo);
                    this.transfer.setResumeableMultipartUploadAfterFailed(true);
                }
            } else {
                this.uploadComplete();
            }
            return result;
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            throw new CosClientException("Upload canceled");
        }
        catch (Exception e) {
            this.uploadFailed();
            throw e;
        }
    }

    void uploadComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    void uploadFailed() {
        this.transfer.setState(Transfer.TransferState.Failed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
        }
    }

    PauseResult<PersistableUpload> pause(boolean forceCancel) {
        PersistableUpload persistableUpload = this.multipartUploadCallable.getPersistableUpload();
        if (persistableUpload == null) {
            PauseStatus pauseStatus = TransferManagerUtils.determinePauseStatus(this.transfer.getState(), forceCancel);
            if (forceCancel) {
                this.cancelFutures();
                this.multipartUploadCallable.performAbortMultipartUpload();
            }
            return new PauseResult<PersistableUpload>(pauseStatus);
        }
        this.cancelFutures();
        return new PauseResult<PersistableUpload>(PauseStatus.SUCCESS, persistableUpload);
    }

    private void cancelFutures() {
        this.cancelFuture();
        for (Future<PartETag> f : this.futures) {
            f.cancel(true);
        }
        this.multipartUploadCallable.getFutures().clear();
        this.futures.clear();
    }

    void performAbort() {
        this.cancelFutures();
        this.multipartUploadCallable.performAbortMultipartUpload();
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
    }
}

