/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos;

import com.qcloud.cos.COS;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.http.AbstractCosHttpClient;
import com.qcloud.cos.http.DefaultCosHttpClient;
import com.qcloud.cos.op.FileOp;
import com.qcloud.cos.op.FolderOp;
import com.qcloud.cos.request.AbstractBaseRequest;
import com.qcloud.cos.request.CreateFolderRequest;
import com.qcloud.cos.request.DelFileRequest;
import com.qcloud.cos.request.DelFolderRequest;
import com.qcloud.cos.request.GetFileInputStreamRequest;
import com.qcloud.cos.request.GetFileLocalRequest;
import com.qcloud.cos.request.ListFolderRequest;
import com.qcloud.cos.request.MoveFileRequest;
import com.qcloud.cos.request.StatFileRequest;
import com.qcloud.cos.request.StatFolderRequest;
import com.qcloud.cos.request.UpdateFileRequest;
import com.qcloud.cos.request.UpdateFolderRequest;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.request.UploadSliceFileRequest;
import com.qcloud.cos.sign.Credentials;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSClient
implements COS {
    private static final Logger LOG = LoggerFactory.getLogger(COSClient.class);
    private ClientConfig config;
    private Credentials cred;
    private AbstractCosHttpClient client;
    private FileOp fileOp;
    private FolderOp folderOp;

    public COSClient(long appId, String secretId, String secretKey) {
        this(new Credentials(appId, secretId, secretKey));
    }

    public COSClient(Credentials cred) {
        this(new ClientConfig(), cred);
    }

    public void setConfig(ClientConfig config) {
        this.config = config;
        this.fileOp.setConfig(config);
        this.folderOp.setConfig(config);
        this.client.shutdown();
        this.client = new DefaultCosHttpClient(config);
        this.fileOp.setHttpClient(this.client);
        this.folderOp.setHttpClient(this.client);
    }

    public void setCred(Credentials cred) {
        this.cred = cred;
        this.fileOp.setCred(cred);
        this.folderOp.setCred(cred);
    }

    public COSClient(ClientConfig config, Credentials cred) {
        this.config = config;
        this.cred = cred;
        this.client = new DefaultCosHttpClient(config);
        this.fileOp = new FileOp(this.config, this.cred, this.client);
        this.folderOp = new FolderOp(this.config, this.cred, this.client);
    }

    private void recordException(String methodName, AbstractBaseRequest request, String message) {
        LOG.warn(methodName + " occur a exception, request:{}, message:{}", (Object)request, (Object)message);
    }

    @Override
    public String updateFolder(UpdateFolderRequest request) {
        try {
            return this.folderOp.updateFolder(request);
        }
        catch (AbstractCosException e) {
            this.recordException("updateFolder", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("updateFolder", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String updateFile(UpdateFileRequest request) {
        try {
            return this.fileOp.updateFile(request);
        }
        catch (AbstractCosException e) {
            this.recordException("updateFile", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("updateFile", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String delFolder(DelFolderRequest request) {
        try {
            return this.folderOp.delFolder(request);
        }
        catch (AbstractCosException e) {
            this.recordException("deleteFolder", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("deleteFolder", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String moveFile(MoveFileRequest request) {
        try {
            return this.fileOp.moveFile(request);
        }
        catch (AbstractCosException e) {
            this.recordException("moveFile", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("moveFile", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String delFile(DelFileRequest request) {
        try {
            return this.fileOp.delFile(request);
        }
        catch (AbstractCosException e) {
            this.recordException("deleteFile", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("deleteFile", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String statFolder(StatFolderRequest request) {
        try {
            return this.folderOp.statFolder(request);
        }
        catch (AbstractCosException e) {
            this.recordException("getFolderStat", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("getFolderStat", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String statFile(StatFileRequest request) {
        try {
            return this.fileOp.statFile(request);
        }
        catch (AbstractCosException e) {
            this.recordException("getFileStat", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("getFileStat", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String createFolder(CreateFolderRequest request) {
        try {
            return this.folderOp.createFolder(request);
        }
        catch (AbstractCosException e) {
            this.recordException("createFolder", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("createFolder", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String listFolder(ListFolderRequest request) {
        try {
            return this.folderOp.listFolder(request);
        }
        catch (AbstractCosException e) {
            this.recordException("getFolderList", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("getFolderList", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String uploadFile(UploadFileRequest request) {
        try {
            return this.fileOp.uploadFile(request);
        }
        catch (AbstractCosException e) {
            this.recordException("uploadFile", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("uploadFile", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String uploadSingleFile(UploadFileRequest request) {
        try {
            return this.fileOp.uploadSingleFile(request);
        }
        catch (AbstractCosException e) {
            this.recordException("uploadSingleFile", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("uploadSingleFile", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public String uploadSliceFile(UploadSliceFileRequest request) {
        try {
            return this.fileOp.uploadSliceFile(request);
        }
        catch (AbstractCosException e) {
            this.recordException("uploadSliceFile", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("uploadSliceFile", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public InputStream getFileInputStream(GetFileInputStreamRequest request) throws Exception {
        try {
            return this.fileOp.getFileInputStream(request);
        }
        catch (AbstractCosException e) {
            this.recordException("getFileInputStream", request, e.toString());
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("getFileInputStream", request, e1.toString());
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public String getFileLocal(GetFileLocalRequest request) {
        try {
            return this.fileOp.getFileLocal(request);
        }
        catch (AbstractCosException e) {
            this.recordException("getFileLocalRequest", request, e.toString());
            return e.toString();
        }
        catch (Exception e) {
            UnknownException e1 = new UnknownException(e.toString());
            this.recordException("getFileLocalRequest", request, e1.toString());
            return e1.toString();
        }
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }
}

