/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.checks.LineSeparatorOption;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;

public class NewlineAtEndOfFileCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY_UNABLE_OPEN = "unable.open";
    public static final String MSG_KEY_NO_NEWLINE_EOF = "noNewlineAtEOF";
    private LineSeparatorOption lineSeparator = LineSeparatorOption.SYSTEM;

    @Override
    protected void processFiltered(File file, FileText fileText) {
        try {
            this.readAndCheckFile(file);
        }
        catch (IOException ignored) {
            this.log(0, MSG_KEY_UNABLE_OPEN, file.getPath());
        }
    }

    public void setLineSeparator(String lineSeparatorParam) {
        try {
            this.lineSeparator = Enum.valueOf(LineSeparatorOption.class, lineSeparatorParam.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("unable to parse " + lineSeparatorParam, iae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndCheckFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        boolean threw = true;
        try {
            if (!this.endsWithNewline(randomAccessFile)) {
                this.log(0, MSG_KEY_NO_NEWLINE_EOF, file.getPath());
            }
            threw = false;
        }
        finally {
            Closeables.close((Closeable)randomAccessFile, (boolean)threw);
        }
    }

    private boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        boolean result;
        int len = this.lineSeparator.length();
        if (randomAccessFile.length() < (long)len) {
            result = false;
        } else {
            randomAccessFile.seek(randomAccessFile.length() - (long)len);
            byte[] lastBytes = new byte[len];
            int readBytes = randomAccessFile.read(lastBytes);
            if (readBytes != len) {
                throw new IOException("Unable to read " + len + " bytes, got " + readBytes);
            }
            result = this.lineSeparator.matches(lastBytes);
        }
        return result;
    }
}

