/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressElement;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SuppressionsLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Suppressions 1.0//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/suppressions_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Suppressions 1.1//EN";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/suppressions_1_1.dtd";
    private static final String UNABLE_TO_FIND_ERROR_MESSAGE = "Unable to find: ";
    private final FilterSet filterChain = new FilterSet();

    private SuppressionsLoader() throws ParserConfigurationException, SAXException {
        super(SuppressionsLoader.createIdToResourceNameMap());
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("suppress".equals(qName)) {
            SuppressElement suppress;
            String checks = attributes.getValue("checks");
            String modId = attributes.getValue("id");
            if (checks == null && modId == null) {
                throw new SAXException("missing checks and id attribute");
            }
            try {
                String files = attributes.getValue("files");
                String lines = attributes.getValue("lines");
                String columns = attributes.getValue("columns");
                suppress = new SuppressElement(files, checks, modId, lines, columns);
            }
            catch (PatternSyntaxException ex) {
                throw new SAXException("invalid files or checks format", ex);
            }
            this.filterChain.addFilter(suppress);
        }
    }

    public static FilterSet loadSuppressions(String filename) throws CheckstyleException {
        URI uri = CommonUtils.getUriByFilename(filename);
        InputSource source = new InputSource(uri.toString());
        return SuppressionsLoader.loadSuppressions(source, filename);
    }

    private static FilterSet loadSuppressions(InputSource source, String sourceName) throws CheckstyleException {
        try {
            SuppressionsLoader suppressionsLoader = new SuppressionsLoader();
            suppressionsLoader.parseInputSource(source);
            return suppressionsLoader.filterChain;
        }
        catch (FileNotFoundException ex) {
            throw new CheckstyleException(UNABLE_TO_FIND_ERROR_MESSAGE + sourceName, ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            String message = String.format(Locale.ROOT, "Unable to parse %s - %s", sourceName, ex.getMessage());
            throw new CheckstyleException(message, ex);
        }
        catch (IOException ex) {
            throw new CheckstyleException("Unable to read " + sourceName, ex);
        }
        catch (NumberFormatException ex) {
            String message = String.format(Locale.ROOT, "Number format exception %s - %s", sourceName, ex.getMessage());
            throw new CheckstyleException(message, ex);
        }
    }

    private static Map<String, String> createIdToResourceNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
        return map;
    }
}

