/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ArrayTypeStyleCheck
extends AbstractCheck {
    public static final String MSG_KEY = "array.type.style";
    private boolean javaStyle = true;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{17};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST variableAST;
        DetailAST typeAST = ast.getParent();
        if (typeAST.getType() == 13 && typeAST.getParent().getType() != 9 && (variableAST = typeAST.getNextSibling()) != null) {
            boolean isJavaStyle;
            boolean bl = isJavaStyle = variableAST.getLineNo() > ast.getLineNo() || variableAST.getColumnNo() - ast.getColumnNo() > -1;
            if (isJavaStyle != this.javaStyle) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, new Object[0]);
            }
        }
    }

    public void setJavaStyle(boolean javaStyle) {
        this.javaStyle = javaStyle;
    }
}

