/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AbstractCheck
extends AbstractViolationReporter {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private final ThreadLocal<FileContext> context = ThreadLocal.withInitial(() -> new FileContext());
    private final Set<String> tokens = new HashSet<String>();
    private int tabWidth = 8;
    private ClassLoader classLoader;

    public abstract int[] getDefaultTokens();

    public abstract int[] getAcceptableTokens();

    public abstract int[] getRequiredTokens();

    public boolean isCommentNodesRequired() {
        return false;
    }

    public final void setTokens(String ... strRep) {
        Collections.addAll(this.tokens, strRep);
    }

    public final Set<String> getTokenNames() {
        return Collections.unmodifiableSet(this.tokens);
    }

    public SortedSet<LocalizedMessage> getMessages() {
        return new TreeSet<LocalizedMessage>(this.context.get().messages);
    }

    public final void clearMessages() {
        this.context.get().messages.clear();
    }

    public void init() {
    }

    public void destroy() {
    }

    public void beginTree(DetailAST rootAST) {
    }

    public void finishTree(DetailAST rootAST) {
    }

    public void visitToken(DetailAST ast) {
    }

    public void leaveToken(DetailAST ast) {
    }

    public final String[] getLines() {
        return this.context.get().fileContents.getLines();
    }

    public final String getLine(int index) {
        return this.context.get().fileContents.getLine(index);
    }

    public final void setFileContents(FileContents contents) {
        this.context.get().fileContents = contents;
    }

    public final FileContents getFileContents() {
        return this.context.get().fileContents;
    }

    public final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected final int getTabWidth() {
        return this.tabWidth;
    }

    public final void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public final void log(DetailAST ast, String key, Object ... args) {
        int col = 1 + CommonUtil.lengthExpandedTabs(this.getLines()[ast.getLineNo() - 1], ast.getColumnNo(), this.tabWidth);
        this.context.get().messages.add(new LocalizedMessage(ast.getLineNo(), col, ast.getColumnNo(), ast.getType(), this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    @Override
    public final void log(int line, String key, Object ... args) {
        this.context.get().messages.add(new LocalizedMessage(line, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    @Override
    public final void log(int lineNo, int colNo, String key, Object ... args) {
        int col = 1 + CommonUtil.lengthExpandedTabs(this.getLines()[lineNo - 1], colNo, this.tabWidth);
        this.context.get().messages.add(new LocalizedMessage(lineNo, col, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    private static class FileContext {
        private final SortedSet<LocalizedMessage> messages = new TreeSet<LocalizedMessage>();
        private FileContents fileContents;

        private FileContext() {
        }
    }
}

