/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.util;

import java.util.concurrent.TimeUnit;

public class StopWatch {
    private long m_startInstant = -1L;
    private long m_stopInstant = -1L;

    public void start() {
        this.m_startInstant = System.currentTimeMillis();
        this.m_stopInstant = -1L;
    }

    public void stop() {
        if (this.m_startInstant == -1L) {
            throw new IllegalStateException("An attempt was made to stop a StopWatch that was not previously started.");
        }
        this.m_stopInstant = System.currentTimeMillis();
    }

    public long getElapsedTimeIn(TimeUnit units) {
        if (this.m_startInstant != -1L) {
            long endTime = this.m_stopInstant == -1L ? System.currentTimeMillis() : this.m_stopInstant;
            long durationMS = endTime - this.m_startInstant;
            return units.convert(durationMS, TimeUnit.MILLISECONDS);
        }
        throw new IllegalStateException("An attempt was made to get the duration elapse of a StopWatch that was not previously started.");
    }
}

