/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.util;

import com.oracle.tools.util.PerpetualIterator;
import java.util.Iterator;
import java.util.Random;

public class RandomIterator
implements Iterator<Long> {
    private Iterator<Long> m_ranges;
    private Random m_random;

    public RandomIterator(Iterator<Long> ranges) {
        this.m_ranges = ranges;
        this.m_random = new Random(System.nanoTime());
    }

    public RandomIterator(long range) {
        this(new PerpetualIterator<Long>(range));
    }

    @Override
    public boolean hasNext() {
        return this.m_ranges.hasNext();
    }

    @Override
    public Long next() {
        long range = this.m_ranges.next();
        long random = Math.abs(this.m_random.nextLong());
        return range == 0L ? 0L : random % range;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from a " + this.getClass().getName());
    }
}

