/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.util;

import com.oracle.tools.util.CompletionListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureCompletionListener<T>
implements CompletionListener<T>,
Future<T> {
    private boolean hasResult = false;
    private T result = null;
    private Exception exception = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(T result) {
        FutureCompletionListener futureCompletionListener = this;
        synchronized (futureCompletionListener) {
            if (!this.hasResult) {
                this.hasResult = true;
                this.result = result;
                this.exception = null;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(Exception exception) {
        FutureCompletionListener futureCompletionListener = this;
        synchronized (futureCompletionListener) {
            if (!this.hasResult) {
                this.hasResult = true;
                this.result = null;
                this.exception = exception;
                this.notifyAll();
            }
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        FutureCompletionListener futureCompletionListener = this;
        synchronized (futureCompletionListener) {
            return this.hasResult;
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        FutureCompletionListener futureCompletionListener = this;
        synchronized (futureCompletionListener) {
            if (!this.hasResult) {
                this.wait();
            }
            if (this.hasResult) {
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                return this.result;
            }
            throw new InterruptedException("Interrupted while waiting for a result");
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        FutureCompletionListener futureCompletionListener = this;
        synchronized (futureCompletionListener) {
            if (!this.hasResult) {
                unit.timedWait(this, timeout);
            }
            if (this.hasResult) {
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                return this.result;
            }
            throw new TimeoutException();
        }
    }
}

