/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.util;

import java.util.Iterator;

public class ExponentialIterator
implements Iterator<Long> {
    private double m_initial;
    private double m_rate;
    private long m_iteration;

    public ExponentialIterator(double initial, double percentage) {
        this.m_initial = initial;
        this.m_rate = 1.0 + percentage / 100.0;
        this.m_iteration = 0L;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Long next() {
        long result = this.m_iteration == 0L ? Math.round(this.m_initial) : Math.round(this.m_initial + Math.pow(this.m_rate, this.m_iteration - 1L));
        ++this.m_iteration;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from a " + this.getClass().getName());
    }
}

