/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.util;

import java.util.concurrent.TimeUnit;

public class Duration {
    public static final Duration ZERO = Duration.of(0L, TimeUnit.MILLISECONDS);
    private long amount;
    private TimeUnit units;

    private Duration(long amount, TimeUnit units) {
        this.amount = amount;
        this.units = units;
    }

    public long getAmount() {
        return this.amount;
    }

    public TimeUnit getUnits() {
        return this.units;
    }

    public long to(TimeUnit units) {
        return units.convert(this.getAmount(), this.getUnits());
    }

    public String toString() {
        return this.getAmount() + " " + this.getUnits().name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Duration timeout = (Duration)other;
        if (this.amount != timeout.amount) {
            return false;
        }
        return this.units == timeout.units;
    }

    public int hashCode() {
        int result = (int)(this.amount ^ this.amount >>> 32);
        result = 31 * result + this.units.hashCode();
        return result;
    }

    public static Duration of(long duration, TimeUnit units) {
        return new Duration(duration, units);
    }

    public static Duration of(String duration) {
        TimeUnit units;
        if ((duration = duration.trim().toLowerCase()).endsWith("ms")) {
            units = TimeUnit.MILLISECONDS;
            duration = duration.substring(0, duration.length() - 2).trim();
        } else if (duration.endsWith("s")) {
            units = TimeUnit.SECONDS;
            duration = duration.substring(0, duration.length() - 1).trim();
        } else if (duration.endsWith("m")) {
            units = TimeUnit.MINUTES;
            duration = duration.substring(0, duration.length() - 1).trim();
        } else if (duration.endsWith("h")) {
            units = TimeUnit.HOURS;
            duration = duration.substring(0, duration.length() - 1).trim();
        } else {
            units = TimeUnit.MILLISECONDS;
        }
        return Duration.of(Long.valueOf(duration), units);
    }
}

