/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.util;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public class Capture<T>
implements Iterator<T> {
    private Iterator<T> iterator;
    private AtomicReference<T> capture;

    public Capture(Iterator<T> iterator) {
        this.iterator = iterator;
        this.capture = null;
    }

    public boolean hasValue() {
        return this.capture != null;
    }

    public T get() {
        return this.next();
    }

    @Override
    public boolean hasNext() {
        return this.hasValue() || this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasValue()) {
            this.capture = new AtomicReference<T>(this.iterator.next());
        }
        return this.capture.get();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from a Capture");
    }
}

