/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.table;

import com.oracle.tools.Option;
import com.oracle.tools.Options;
import com.oracle.tools.table.Cell;
import java.util.ArrayList;
import java.util.Iterator;

public class Row
implements Iterable<Cell> {
    private ArrayList<Cell> cells = new ArrayList();
    private Options options;

    public Row(Cell ... cells) {
        if (cells != null) {
            for (Cell cell : cells) {
                this.cells.add(cell);
            }
        }
        this.options = new Options(new Option[0]);
    }

    public int width() {
        return this.cells.size();
    }

    public Row addCell(Cell cell) {
        this.cells.add(cell);
        return this;
    }

    public Row addCell(String cell) {
        return this.addCell(new Cell(cell));
    }

    public Cell getCell(int index) {
        if (index < 0 || index >= this.cells.size()) {
            return null;
        }
        return this.cells.get(index);
    }

    public Options getOptions() {
        return this.options;
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cells.iterator();
    }

    public static interface Comparator
    extends Option,
    java.util.Comparator<Row> {
    }
}

