/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.table;

import com.oracle.tools.Option;
import com.oracle.tools.Options;
import java.util.ArrayList;

public class Cell {
    private ArrayList<String> lines = new ArrayList();
    private Options options;

    public Cell(String ... lines) {
        if (lines != null) {
            for (String content : lines) {
                for (String line : content.split("\\n\\r|\\n")) {
                    this.lines.add(line);
                }
            }
        }
        this.options = new Options(new Option[0]);
    }

    public Options getOptions() {
        return this.options;
    }

    public String getLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return null;
        }
        return this.lines.get(index);
    }

    public boolean isEmpty() {
        for (String line : this.lines) {
            if (line.length() <= 0 || line.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int height() {
        return this.lines.size();
    }

    public int width() {
        int maximum = 0;
        for (String line : this.lines) {
            if (line.length() <= maximum) continue;
            maximum = line.length();
        }
        return maximum;
    }

    public static class Width
    implements Option {
        private static Width AUTODETECT = new Width(-1);
        private int characters;

        private Width(int characters) {
            this.characters = characters;
        }

        public boolean isAutoDetect() {
            return this.characters < 0;
        }

        public int getCharacters() {
            return this.characters;
        }

        public static Width autodetect() {
            return AUTODETECT;
        }

        public static Width of(int characters) {
            return new Width(characters);
        }
    }

    public static class Separator
    implements Option {
        private static final Separator STANDARD = new Separator(":");
        private String separator;

        private Separator(String separator) {
            this.separator = separator;
        }

        public String getSeparator() {
            return this.separator;
        }

        public static Separator of(String separator) {
            return new Separator(separator);
        }

        public static Separator standard() {
            return STANDARD;
        }
    }

    public static enum Justification implements Option
    {
        LEFT,
        RIGHT;


        public String format(String content, int width) {
            return this == LEFT ? String.format("%1$-" + width + "s", content) : String.format("%1$" + width + "s", content);
        }
    }
}

