/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.predicate;

import com.oracle.tools.predicate.Predicate;
import java.util.Arrays;

public class AllOf<T>
implements Predicate<T> {
    private Predicate<? super T>[] predicates;

    public AllOf(Predicate<? super T> ... predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean evaluate(T value) {
        if (this.predicates == null) {
            return false;
        }
        for (Predicate<T> predicate : this.predicates) {
            if (predicate.evaluate(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "AllOf{" + Arrays.toString(this.predicates) + '}';
    }
}

