/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.lang;

public final class StringHelper {
    public static String unquote(String string) {
        string = string != null ? string.trim() : string;
        return string != null && (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) ? (string = string.substring(1, string.length() - 1)) : string;
    }

    public static String dequote(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'' || c == '`') continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String doubleQuoteIfNecessary(String string) {
        return string != null && string.contains(" ") && !string.startsWith("\"") && !string.endsWith("\"") ? "\"" + string + "\"" : string;
    }

    public static String repeat(String string, int count) {
        int len = count * string.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < count; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String trimTrailingWhiteSpace(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder builder = new StringBuilder(string);
        while (builder.length() > 0 && Character.isWhitespace(builder.charAt(builder.length() - 1))) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

