/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.io;

import com.oracle.tools.predicate.Predicate;
import com.oracle.tools.predicate.Predicates;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class NetworkHelper {
    public static final Predicate<InetAddress> LOOPBACK_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean evaluate(InetAddress address) {
            return address != null && address.isLoopbackAddress();
        }

        public String toString() {
            return "LOOPBACK";
        }
    };
    public static final Predicate<InetAddress> NON_LOOPBACK_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean evaluate(InetAddress address) {
            return address != null && !address.isLoopbackAddress();
        }

        public String toString() {
            return "NON-LOOPBACK";
        }
    };
    public static final Predicate<InetAddress> IPv4_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean evaluate(InetAddress address) {
            return address instanceof Inet4Address;
        }

        public String toString() {
            return "IPv4-ADDRESS";
        }
    };
    public static final Predicate<InetAddress> IPv6_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean evaluate(InetAddress address) {
            return address instanceof Inet6Address;
        }

        public String toString() {
            return "IPv6-ADDRESS";
        }
    };
    public static final Predicate<InetAddress> LINK_LOCAL_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean evaluate(InetAddress address) {
            return address != null && address.isLinkLocalAddress();
        }

        public String toString() {
            return "LINK-LOCAL-ADDRESS";
        }
    };
    public static final Predicate<InetAddress> ANY_LOCAL_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean evaluate(InetAddress address) {
            return address != null && address.isAnyLocalAddress();
        }

        public String toString() {
            return "ANY-LOCAL-ADDRESS";
        }
    };
    public static final Predicate<InetAddress> DEFAULT_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean evaluate(InetAddress address) {
            Predicate<InetAddress> predicate = Boolean.getBoolean("java.net.preferIPv4Stack") ? IPv4_ADDRESS : (Boolean.getBoolean("java.net.preferIPv6Addresses") ? IPv6_ADDRESS : Predicates.always());
            return predicate.evaluate(address);
        }
    };
    public static final Predicate<InetAddress> BINDABLE_ADDRESS = new Predicate<InetAddress>(){

        /*
         * Exception decompiling
         */
        @Override
        public boolean evaluate(InetAddress address) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String toString() {
            return "BINDABLE_ADDRESS";
        }
    };

    public static InetAddress getInetAddress(Predicate<InetAddress> predicate) throws SocketException {
        for (NetworkInterface networkInterface : NetworkHelper.getNetworkInterfaces(Predicates.always())) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!predicate.evaluate(address)) continue;
                return address;
            }
        }
        return null;
    }

    public static List<InetAddress> getInetAddresses(Predicate<InetAddress> predicate) {
        LinkedList<InetAddress> addressList = new LinkedList<InetAddress>();
        for (NetworkInterface networkInterface : NetworkHelper.getNetworkInterfaces(Predicates.always())) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                try {
                    if (!predicate.evaluate(address)) continue;
                    addressList.add(address);
                }
                catch (Exception e) {}
            }
        }
        return addressList;
    }

    public static List<NetworkInterface> getNetworkInterfaces(Predicate<NetworkInterface> predicate) {
        ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!predicate.evaluate(networkInterface)) continue;
                networkInterfaces.add(networkInterface);
            }
            Collections.sort(networkInterfaces, new Comparator<NetworkInterface>(){

                @Override
                public int compare(NetworkInterface networkInterface1, NetworkInterface networkInterface2) {
                    return networkInterface1.getIndex() - networkInterface2.getIndex();
                }
            });
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return networkInterfaces;
    }

    public static InetAddress getFeasibleLocalHost() {
        try {
            InetAddress potentialInetAddress = null;
            for (NetworkInterface networkInterface : NetworkHelper.getNetworkInterfaces(Predicates.always())) {
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!BINDABLE_ADDRESS.evaluate(inetAddress) || inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.isSiteLocalAddress()) {
                        return inetAddress;
                    }
                    if (potentialInetAddress != null) continue;
                    potentialInetAddress = inetAddress;
                }
            }
            if (potentialInetAddress == null) {
                potentialInetAddress = InetAddress.getLocalHost();
            }
            if (potentialInetAddress == null) {
                potentialInetAddress = InetAddress.getLoopbackAddress();
            }
            return potentialInetAddress;
        }
        catch (Exception e) {
            return InetAddress.getLoopbackAddress();
        }
    }

    public static InetAddress getWildcardAddress() {
        return new InetSocketAddress(0).getAddress();
    }
}

