/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred.listener;

import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TemporarilyUnavailableException;
import com.oracle.tools.util.CompletionListener;

public class DeferredCompletionListener<T>
implements Deferred<T>,
CompletionListener<T> {
    private Class<T> deferredClass;
    private T result;
    private Exception exception;
    private boolean hasResult;

    public DeferredCompletionListener(Class<T> deferredClass) {
        this.deferredClass = deferredClass;
        this.result = null;
        this.exception = null;
        this.hasResult = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(T result) {
        DeferredCompletionListener deferredCompletionListener = this;
        synchronized (deferredCompletionListener) {
            if (this.hasResult) {
                throw new IllegalStateException("Attempted to use a DeferredCompletionListener for more than one purpose");
            }
            this.hasResult = true;
            this.result = result;
            this.exception = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(Exception exception) {
        DeferredCompletionListener deferredCompletionListener = this;
        synchronized (deferredCompletionListener) {
            if (this.hasResult) {
                throw new IllegalStateException("Attempted to use a DeferredCompletionListener for more than one purpose");
            }
            this.hasResult = true;
            this.result = null;
            this.exception = exception;
        }
    }

    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        DeferredCompletionListener deferredCompletionListener = this;
        synchronized (deferredCompletionListener) {
            if (this.hasResult) {
                if (this.exception == null) {
                    return this.result;
                }
                throw new PermanentlyUnavailableException(this, (Throwable)this.exception);
            }
            throw new TemporarilyUnavailableException(this);
        }
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.deferredClass;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeferredCompletionListener<" + this.deferredClass + ">{");
        builder.append(this.hasResult ? (this.exception == null ? this.result : this.exception) : "(no result)");
        builder.append("}");
        return builder.toString();
    }
}

