/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred.jmx;

import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TemporarilyUnavailableException;
import com.oracle.tools.deferred.UnavailableException;
import java.io.IOException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class DeferredMBeanProxy<T>
implements Deferred<T> {
    private Deferred<JMXConnector> deferredJMXConnector;
    private ObjectName objectName;
    private Class<T> proxyClass;

    public DeferredMBeanProxy(Deferred<JMXConnector> deferredJMXConnector, ObjectName objectName, Class<T> proxyClass) {
        this.deferredJMXConnector = deferredJMXConnector;
        this.objectName = objectName;
        this.proxyClass = proxyClass;
    }

    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        try {
            JMXConnector connector = this.deferredJMXConnector.get();
            if (connector == null) {
                throw new TemporarilyUnavailableException(this);
            }
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            return JMX.newMBeanProxy(connection, this.objectName, this.proxyClass);
        }
        catch (IOException e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.proxyClass;
    }

    public String toString() {
        return String.format("Deferred<MBeanProxy>{on=%s, object=%s, class=%s}", this.deferredJMXConnector, this.objectName, this.proxyClass);
    }
}

