/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred.jmx;

import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TemporarilyUnavailableException;
import com.oracle.tools.deferred.UnavailableException;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class DeferredMBeanInfo
implements Deferred<MBeanInfo> {
    private Deferred<JMXConnector> deferredJMXConnector;
    private ObjectName objectName;

    public DeferredMBeanInfo(Deferred<JMXConnector> deferredJMXConnector, ObjectName objectName) {
        this.deferredJMXConnector = deferredJMXConnector;
        this.objectName = objectName;
    }

    @Override
    public MBeanInfo get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        try {
            JMXConnector connector = this.deferredJMXConnector.get();
            if (connector == null) {
                throw new TemporarilyUnavailableException(this);
            }
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            return connection.getMBeanInfo(this.objectName);
        }
        catch (IOException e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
    }

    @Override
    public Class<MBeanInfo> getDeferredClass() {
        return MBeanInfo.class;
    }

    public String toString() {
        return String.format("Deferred<MBeanInfo>{on=%s, object=%s}", this.deferredJMXConnector, this.objectName);
    }
}

