/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred.jmx;

import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TemporarilyUnavailableException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DeferredJMXConnector
implements Deferred<JMXConnector> {
    private String jmxConnectionURL;
    private JMXConnectorBuilder jmxConnectorBuilder;

    public DeferredJMXConnector(String jmxConnectionURL) {
        this.jmxConnectionURL = jmxConnectionURL;
        this.jmxConnectorBuilder = new StandardJMXConnectorBuilder();
    }

    public DeferredJMXConnector(String jmxConnectionURL, JMXConnectorBuilder jmxConnectorBuilder) {
        this.jmxConnectionURL = jmxConnectionURL;
        this.jmxConnectorBuilder = jmxConnectorBuilder;
    }

    public String getJMXConnectionURL() {
        return this.jmxConnectionURL;
    }

    @Override
    public JMXConnector get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        String username = "";
        String password = "";
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] credentials = new String[]{username, password};
        env.put("jmx.remote.credentials", credentials);
        try {
            JMXConnector connector = this.jmxConnectorBuilder.realize(new JMXServiceURL(this.jmxConnectionURL), env);
            connector.connect();
            return connector;
        }
        catch (IOException e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
        catch (Exception e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
    }

    @Override
    public Class<JMXConnector> getDeferredClass() {
        return JMXConnector.class;
    }

    public String toString() {
        return String.format("Deferred<JMXConnector>{%s}", this.jmxConnectionURL);
    }

    public static class StandardJMXConnectorBuilder
    implements JMXConnectorBuilder {
        @Override
        public JMXConnector realize(JMXServiceURL url, Map<String, ?> env) throws IOException {
            return JMXConnectorFactory.newJMXConnector(url, env);
        }
    }

    public static interface JMXConnectorBuilder {
        public JMXConnector realize(JMXServiceURL var1, Map<String, ?> var2) throws IOException;
    }
}

