/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred;

import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TemporarilyUnavailableException;
import java.util.concurrent.TimeUnit;

public class Supervised<T>
implements Deferred<T> {
    private Deferred<T> deferred;
    private volatile long instantOfLastFailure;
    private long retryDelayDuration;
    private TimeUnit retryDelayTimeUnit;

    public Supervised(Deferred<T> deferred) {
        this.deferred = deferred;
        this.instantOfLastFailure = -1L;
        this.retryDelayDuration = 250L;
        this.retryDelayTimeUnit = TimeUnit.MILLISECONDS;
    }

    public Deferred<T> getDeferred() {
        return this.deferred;
    }

    public boolean isAccessible() {
        return this.instantOfLastFailure < 0L || System.currentTimeMillis() > this.instantOfLastFailure + this.retryDelayTimeUnit.toMillis(this.retryDelayDuration);
    }

    public void resourceNoLongerAvailable() {
        this.instantOfLastFailure = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        if (this.isAccessible()) {
            Supervised supervised = this;
            synchronized (supervised) {
                if (this.isAccessible()) {
                    try {
                        return this.deferred.get();
                    }
                    catch (PermanentlyUnavailableException e) {
                        this.resourceNoLongerAvailable();
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.resourceNoLongerAvailable();
                        throw e;
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.deferred.getDeferredClass();
    }

    public String toString() {
        return String.format("Supervised<%s>{%s}", this.getDeferredClass(), this.getDeferred());
    }
}

