/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred;

import com.oracle.tools.deferred.DeferredHelper;
import com.oracle.tools.deferred.TimeoutConstraint;
import com.oracle.tools.util.Duration;
import java.util.concurrent.TimeUnit;

public class SimpleTimeoutConstraint
implements TimeoutConstraint {
    private Duration initialDelay;
    private Duration maximumPollingDelay;
    private Duration maximumRetryDuration;
    private Iterable<Duration> retryDurations;

    public SimpleTimeoutConstraint() {
        this.initialDelay = Duration.of(0L, TimeUnit.MILLISECONDS);
        this.maximumPollingDelay = DeferredHelper.getDefaultEnsuredMaximumPollingDuration();
        this.maximumRetryDuration = DeferredHelper.getDefaultEnsuredMaximumRetryDuration();
        this.retryDurations = DeferredHelper.getDefaultEnsuredRetryDurationsIterable();
    }

    public SimpleTimeoutConstraint(Duration initialDelay, Duration maximumPollingDelay, Duration maximumRetryDuration, Iterable<Duration> retryDurations) {
        this.initialDelay = initialDelay;
        this.maximumPollingDelay = maximumPollingDelay;
        this.maximumRetryDuration = maximumRetryDuration;
        this.retryDurations = retryDurations;
    }

    @Override
    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    @Override
    public Duration getMaximumRetryDuration() {
        return this.maximumRetryDuration;
    }

    @Override
    public Duration getMaximumPollingDelay() {
        return this.maximumPollingDelay;
    }

    @Override
    public Iterable<Duration> getRetryDelayDurations() {
        return this.retryDurations;
    }

    public SimpleTimeoutConstraint within(long duration, TimeUnit units) {
        this.maximumRetryDuration = Duration.of(duration, units);
        return this;
    }

    public SimpleTimeoutConstraint delayedBy(long duration, TimeUnit units) {
        this.initialDelay = Duration.of(duration, units);
        return this;
    }
}

