/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred;

import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.DeferredHelper;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TemporarilyUnavailableException;
import com.oracle.tools.deferred.TimeoutConstraint;
import com.oracle.tools.util.Duration;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class Ensured<T>
implements Deferred<T> {
    private Deferred<T> deferred;
    private long initialDelayDurationMS;
    private long maximumPollingDurationMS;
    private long maximumRetryDurationMS;
    private Iterator<Duration> retryDurations;

    public Ensured(Deferred<T> deferred) {
        this(deferred, null);
    }

    public Ensured(Deferred<T> deferred, TimeoutConstraint constraint) {
        Deferred<T> deferred2 = this.deferred = deferred instanceof Ensured ? ((Ensured)deferred).getDeferred() : deferred;
        if (constraint == null) {
            this.initialDelayDurationMS = 0L;
            this.maximumPollingDurationMS = DeferredHelper.getDefaultEnsuredMaximumPollingDuration().to(TimeUnit.MILLISECONDS);
            this.maximumRetryDurationMS = DeferredHelper.getDefaultEnsuredMaximumRetryDuration().to(TimeUnit.MILLISECONDS);
            this.retryDurations = DeferredHelper.getDefaultEnsuredRetryDurationsIterable().iterator();
        } else {
            this.initialDelayDurationMS = constraint.getInitialDelay().to(TimeUnit.MILLISECONDS);
            this.maximumPollingDurationMS = constraint.getMaximumPollingDelay().to(TimeUnit.MILLISECONDS);
            this.maximumRetryDurationMS = constraint.getMaximumRetryDuration().to(TimeUnit.MILLISECONDS);
            this.retryDurations = constraint.getRetryDelayDurations().iterator();
        }
    }

    @Deprecated
    public Ensured(Deferred<T> deferred, Iterator<Duration> retryDurations, long maximumRetryDurationMS) {
        this.deferred = deferred instanceof Ensured ? ((Ensured)deferred).getDeferred() : deferred;
        this.initialDelayDurationMS = 0L;
        this.maximumPollingDurationMS = DeferredHelper.getDefaultEnsuredMaximumPollingDuration().to(TimeUnit.MILLISECONDS);
        this.maximumRetryDurationMS = maximumRetryDurationMS;
        this.retryDurations = retryDurations;
    }

    public Deferred<T> getDeferred() {
        return this.deferred;
    }

    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        long remainingRetryDurationMS = this.maximumRetryDurationMS;
        do {
            if (this.initialDelayDurationMS > 0L) {
                try {
                    Thread.sleep(this.initialDelayDurationMS);
                }
                catch (InterruptedException e) {
                    throw new PermanentlyUnavailableException(this.deferred, (Throwable)e);
                }
                remainingRetryDurationMS -= this.initialDelayDurationMS;
            }
            long acquisitionDurationMS = 0L;
            try {
                long started = System.currentTimeMillis();
                T object = this.deferred.get();
                long stopped = System.currentTimeMillis();
                acquisitionDurationMS = stopped - started;
                remainingRetryDurationMS -= acquisitionDurationMS < 0L ? 0L : acquisitionDurationMS;
                return object;
            }
            catch (PermanentlyUnavailableException e) {
                throw e;
            }
            catch (UnsupportedOperationException e) {
                throw new PermanentlyUnavailableException(this, (Throwable)e);
            }
            catch (TemporarilyUnavailableException e) {
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (this.maximumRetryDurationMS >= 0L && remainingRetryDurationMS <= 0L) continue;
            if (this.retryDurations.hasNext()) {
                try {
                    Duration duration = this.retryDurations.next();
                    long durationMS = duration.to(TimeUnit.MILLISECONDS);
                    if (durationMS > this.maximumPollingDurationMS) {
                        durationMS = this.maximumPollingDurationMS;
                    }
                    if (remainingRetryDurationMS - durationMS < 0L) {
                        durationMS = remainingRetryDurationMS;
                    }
                    if (durationMS > 0L) {
                        TimeUnit.MILLISECONDS.sleep(durationMS);
                    }
                    remainingRetryDurationMS -= durationMS;
                }
                catch (InterruptedException e) {
                    throw new PermanentlyUnavailableException(this.deferred, (Throwable)e);
                }
            } else {
                throw new PermanentlyUnavailableException(this.deferred);
            }
        } while (this.maximumRetryDurationMS < 0L || remainingRetryDurationMS > 0L);
        throw new PermanentlyUnavailableException(this.deferred);
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.deferred.getDeferredClass();
    }

    public String toString() {
        return String.format("Ensured{%s}", this.getDeferredClass(), this.getDeferred());
    }
}

