/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred;

import com.oracle.tools.deferred.Cached;
import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.DeferredCallable;
import com.oracle.tools.deferred.DeferredInvoke;
import com.oracle.tools.deferred.DeferredPredicate;
import com.oracle.tools.deferred.Ensured;
import com.oracle.tools.deferred.Existing;
import com.oracle.tools.deferred.Future;
import com.oracle.tools.deferred.SimpleTimeoutConstraint;
import com.oracle.tools.deferred.TimeoutConstraint;
import com.oracle.tools.deferred.atomic.DeferredAtomicBoolean;
import com.oracle.tools.deferred.atomic.DeferredAtomicInteger;
import com.oracle.tools.deferred.atomic.DeferredAtomicLong;
import com.oracle.tools.options.Timeout;
import com.oracle.tools.predicate.Predicate;
import com.oracle.tools.util.Duration;
import com.oracle.tools.util.ExponentialIterator;
import com.oracle.tools.util.FibonacciIterator;
import com.oracle.tools.util.MappingIterator;
import com.oracle.tools.util.PerpetualIterator;
import com.oracle.tools.util.RandomIterator;
import com.oracle.tools.util.ReflectionHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class DeferredHelper {
    public static final String ORACLETOOLS_DEFERRED_RETRY_STRATEGY = "oracletools.deferred.retry.strategy";
    public static final String ORACLETOOLS_DEFERRED_RETRY_TIMEOUT = "oracletools.deferred.retry.timeout";
    public static final long ORACLETOOLS_DEFERRED_RETRY_TIMEOUT_SECS = 60L;
    private static final Duration ENSURED_MAXIMUM_RETRY_DURATION;
    public static final String ORACLETOOLS_DEFERRED_MAXIMUM_POLLING_TIME = "oracletools.deferred.maximum.polling.time";
    public static final long ORACLETOOLS_DEFERRED_MAXIMUM_POLLING_TIME_MS = 1000L;
    private static final Duration ENSURED_MAXIMUM_POLLING_DURATION;
    private static final ThreadLocal<Deferred<?>> DEFERRED;
    private static final Iterable<Duration> ENSURED_RETRY_DURATIONS;

    public static Deferred<Long> deferred(AtomicLong atomic) {
        return new DeferredAtomicLong(atomic);
    }

    public static Deferred<Integer> deferred(AtomicInteger atomic) {
        return new DeferredAtomicInteger(atomic);
    }

    public static Deferred<Boolean> deferred(AtomicBoolean atomic) {
        return new DeferredAtomicBoolean(atomic);
    }

    public static <T> Deferred<T> deferred(Callable<T> callable, Class<T> callableReturnType) {
        return new DeferredCallable<T>(callable, callableReturnType);
    }

    public static Iterator<Duration> getDefaultEnsuredRetryDurations() {
        return ENSURED_RETRY_DURATIONS.iterator();
    }

    public static Iterable<Duration> getDefaultEnsuredRetryDurationsIterable() {
        return ENSURED_RETRY_DURATIONS;
    }

    public static Duration getDefaultEnsuredMaximumRetryDuration() {
        return ENSURED_MAXIMUM_RETRY_DURATION;
    }

    public static long getDefaultEnsuredTimeoutMS() {
        String duration = System.getProperty(ORACLETOOLS_DEFERRED_RETRY_TIMEOUT);
        if (duration == null) {
            return TimeUnit.SECONDS.toMillis(60L);
        }
        Timeout timeout = Timeout.after(duration);
        return timeout.to(TimeUnit.MILLISECONDS);
    }

    public static Duration getDefaultEnsuredMaximumPollingDuration() {
        return ENSURED_MAXIMUM_POLLING_DURATION;
    }

    public static <T> Deferred<T> ensured(Deferred<T> deferred) {
        return deferred instanceof Ensured ? deferred : new Ensured(deferred);
    }

    public static <T> Deferred<T> ensured(Deferred<T> deferred, TimeoutConstraint constraint) {
        return deferred instanceof Ensured ? deferred : new Ensured(deferred, constraint);
    }

    public static <T> T ensure(T value) {
        return value;
    }

    public static <T> T ensure(Deferred<T> deferred) {
        return DeferredHelper.ensured(deferred).get();
    }

    public static <T> T ensure(Deferred<T> deferred, TimeoutConstraint constraint) {
        return DeferredHelper.ensured(deferred, constraint).get();
    }

    public static <T> boolean ensure(Deferred<T> deferred, Predicate<? super T> predicate) {
        return DeferredHelper.ensure(new DeferredPredicate<T>(deferred, predicate));
    }

    public static <T> Cached<T> cached(Deferred<T> deferred) {
        return deferred instanceof Cached ? (Cached)deferred : new Cached<T>(deferred);
    }

    public static <T> Deferred<T> future(Class<T> clzOfResult, java.util.concurrent.Future<T> future) {
        return new Future<T>(clzOfResult, future);
    }

    public static <T> T invoking(T object) {
        return DeferredHelper.invoking(new Existing<T>(object));
    }

    public static <T, O extends T> T invoking(O object, Class<T> specificClass) {
        return DeferredHelper.invoking(new Existing<O>(object, specificClass));
    }

    public static <T> T invoking(Deferred<T> deferred) {
        if (DEFERRED.get() == null) {
            T proxy = ReflectionHelper.createProxyOf(deferred.getDeferredClass(), (MethodInterceptor)new DeferredMethodInteceptor());
            DEFERRED.set(deferred);
            return proxy;
        }
        throw new UnsupportedOperationException("An attempt was made to call 'invoking' without being wrapped inside an 'eventually' call. Alternatively two or more calls to 'invoking' have been made sequentially. Calls to 'invoking' must be contained inside an 'eventually' call.");
    }

    public static <T> T valueOf(Deferred<T> deferred) {
        if (DEFERRED.get() == null) {
            DEFERRED.set(deferred);
            return null;
        }
        throw new UnsupportedOperationException("An attempt was made to call 'valueOf' without being wrapped inside of an 'eventually' call. Alternatively two or more calls to 'valueOf' have been made sequentially. Calls to 'valueOf' must be contained inside an 'eventually' call.");
    }

    public static <T> T valueOf(Callable<T> callable, Class<T> returnType) {
        return DeferredHelper.valueOf(DeferredHelper.deferred(callable, returnType));
    }

    public static Integer valueOf(AtomicInteger atomic) {
        return DeferredHelper.valueOf(DeferredHelper.deferred(atomic));
    }

    public static Long valueOf(AtomicLong atomic) {
        return DeferredHelper.valueOf(DeferredHelper.deferred(atomic));
    }

    public static Boolean valueOf(AtomicBoolean atomic) {
        return DeferredHelper.valueOf(DeferredHelper.deferred(atomic));
    }

    public static <T> T valueOf(Callable<T> callable) {
        return (T)DeferredHelper.valueOf(DeferredHelper.deferred(callable, Object.class));
    }

    public static <T> Deferred<T> eventually(T t) {
        Deferred deferred = DEFERRED.get();
        if (deferred == null) {
            deferred = t instanceof Deferred ? (Deferred)t : new Existing<T>(t);
        } else {
            DEFERRED.set(null);
        }
        return DeferredHelper.ensured(deferred);
    }

    public static <T> Deferred<T> eventually(Deferred<T> t) {
        Deferred<Object> deferred = DEFERRED.get();
        if (deferred == null) {
            deferred = t;
        } else {
            DEFERRED.set(null);
        }
        return DeferredHelper.ensured(deferred);
    }

    public static <T> Deferred<T> eventually(T t, TimeoutConstraint constraint) {
        Deferred deferred = DEFERRED.get();
        if (deferred == null) {
            deferred = t instanceof Deferred ? (Deferred)t : new Existing<T>(t);
        } else {
            DEFERRED.set(null);
        }
        return DeferredHelper.ensured(deferred, constraint);
    }

    public static <T> Deferred<T> eventually(Deferred<T> t, TimeoutConstraint constraint) {
        Deferred<Object> deferred = DEFERRED.get();
        if (deferred == null) {
            deferred = t;
        } else {
            DEFERRED.set(null);
        }
        return DeferredHelper.ensured(deferred, constraint);
    }

    public static SimpleTimeoutConstraint within(long duration, TimeUnit units) {
        return new SimpleTimeoutConstraint(Duration.ZERO, ENSURED_MAXIMUM_POLLING_DURATION, Duration.of(duration, units), ENSURED_RETRY_DURATIONS);
    }

    public static SimpleTimeoutConstraint within(Timeout timeout) {
        return new SimpleTimeoutConstraint(Duration.ZERO, ENSURED_MAXIMUM_POLLING_DURATION, timeout.getDuration(), ENSURED_RETRY_DURATIONS);
    }

    public static SimpleTimeoutConstraint delayedBy(long duration, TimeUnit units) {
        return new SimpleTimeoutConstraint(Duration.of(duration, units), ENSURED_MAXIMUM_POLLING_DURATION, ENSURED_MAXIMUM_RETRY_DURATION, ENSURED_RETRY_DURATIONS);
    }

    @Deprecated
    public static <T> Deferred<T> ensured(Deferred<T> deferred, long maximumRetryDuration, TimeUnit maximumRetryDurationUnits) {
        long maximumRetryDurationMS = maximumRetryDurationUnits.toMillis(maximumRetryDuration);
        return deferred instanceof Ensured ? deferred : new Ensured(deferred, new SimpleTimeoutConstraint(Duration.ZERO, ENSURED_MAXIMUM_POLLING_DURATION, ENSURED_MAXIMUM_RETRY_DURATION, ENSURED_RETRY_DURATIONS));
    }

    @Deprecated
    public static <T> Deferred<T> ensured(Deferred<T> deferred, long retryDelayDuration, TimeUnit retryDelayDurationUnits, long totalRetryDuration, TimeUnit totalRetryDurationUnits) {
        PerpetualIterator<Duration> retryDurations = new PerpetualIterator<Duration>(Duration.of(retryDelayDuration < 0L ? 0L : retryDelayDuration, retryDelayDurationUnits));
        return deferred instanceof Ensured ? deferred : new Ensured(deferred, retryDurations, totalRetryDurationUnits.toMillis(totalRetryDuration));
    }

    @Deprecated
    public static <T> Deferred<T> ensured(Deferred<T> deferred, long totalRetryDurationMS) {
        SimpleTimeoutConstraint constraint = new SimpleTimeoutConstraint(Duration.ZERO, ENSURED_MAXIMUM_POLLING_DURATION, Duration.of(totalRetryDurationMS, TimeUnit.MILLISECONDS), ENSURED_RETRY_DURATIONS);
        return deferred instanceof Ensured ? (Ensured)deferred : new Ensured<T>(deferred, constraint);
    }

    @Deprecated
    public static <T> T ensure(Deferred<T> deferred, long totalRetryDuration, TimeUnit totalRetryDurationUnits) {
        SimpleTimeoutConstraint constraint = new SimpleTimeoutConstraint(Duration.ZERO, ENSURED_MAXIMUM_POLLING_DURATION, Duration.of(totalRetryDuration, totalRetryDurationUnits), ENSURED_RETRY_DURATIONS);
        return DeferredHelper.ensured(deferred, constraint).get();
    }

    @Deprecated
    public static <T> T ensure(Deferred<T> deferred, long retryDelayDuration, TimeUnit retryDelayDurationUnits, long totalRetryDuration, TimeUnit totalRetryDurationUnits) {
        return DeferredHelper.ensured(deferred, retryDelayDuration, retryDelayDurationUnits, totalRetryDuration, totalRetryDurationUnits).get();
    }

    @Deprecated
    public static <T> T ensure(Deferred<T> deferred, long totalRetryDurationMS) {
        SimpleTimeoutConstraint constraint = new SimpleTimeoutConstraint(Duration.ZERO, ENSURED_MAXIMUM_POLLING_DURATION, Duration.of(totalRetryDurationMS, TimeUnit.MILLISECONDS), ENSURED_RETRY_DURATIONS);
        return DeferredHelper.ensured(deferred, constraint).get();
    }

    @Deprecated
    public static <T> Deferred<T> eventually(Deferred<T> t, long totalRetryDuration, TimeUnit totalRetryDurationUnits) {
        SimpleTimeoutConstraint constraint = new SimpleTimeoutConstraint(Duration.ZERO, ENSURED_MAXIMUM_POLLING_DURATION, Duration.of(totalRetryDuration, totalRetryDurationUnits), ENSURED_RETRY_DURATIONS);
        return DeferredHelper.eventually(t, (TimeoutConstraint)constraint);
    }

    @Deprecated
    public static <T> Deferred<T> eventually(T t, long totalRetryDuration, TimeUnit totalRetryDurationUnits) {
        SimpleTimeoutConstraint constraint = new SimpleTimeoutConstraint(Duration.ZERO, ENSURED_MAXIMUM_POLLING_DURATION, Duration.of(totalRetryDuration, totalRetryDurationUnits), ENSURED_RETRY_DURATIONS);
        return DeferredHelper.eventually(t, (TimeoutConstraint)constraint);
    }

    static {
        DEFERRED = new ThreadLocal();
        String maximumRetryDuration = System.getProperty(ORACLETOOLS_DEFERRED_RETRY_TIMEOUT, Long.toString(60L) + "s");
        ENSURED_MAXIMUM_RETRY_DURATION = Duration.of(maximumRetryDuration);
        String maximumPollingDuration = System.getProperty(ORACLETOOLS_DEFERRED_MAXIMUM_POLLING_TIME, Long.toString(1000L));
        ENSURED_MAXIMUM_POLLING_DURATION = Duration.of(maximumPollingDuration);
        String strategy = System.getProperty(ORACLETOOLS_DEFERRED_RETRY_STRATEGY, "random.fibonacci");
        strategy = strategy.trim().toLowerCase();
        final MappingIterator.Function<Long, Duration> MILLISECONDS_TO_DURATION = new MappingIterator.Function<Long, Duration>(){

            @Override
            public Duration map(Long milliseconds) {
                return Duration.of(milliseconds, TimeUnit.MILLISECONDS);
            }
        };
        ENSURED_RETRY_DURATIONS = strategy.equals("random.fibonacci") ? new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new MappingIterator(new RandomIterator(new FibonacciIterator()), MILLISECONDS_TO_DURATION);
            }
        } : (strategy.equals("random.exponential") ? new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new MappingIterator(new RandomIterator(new ExponentialIterator(0.0, 50.0)), MILLISECONDS_TO_DURATION);
            }
        } : (strategy.equals("fibonacci") ? new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new MappingIterator(new FibonacciIterator(), MILLISECONDS_TO_DURATION);
            }
        } : (strategy.equals("exponential") ? new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new MappingIterator(new ExponentialIterator(0.0, 50.0), MILLISECONDS_TO_DURATION);
            }
        } : new Iterable<Duration>(){

            @Override
            public Iterator<Duration> iterator() {
                return new PerpetualIterator<Duration>(Duration.of(250L, TimeUnit.MILLISECONDS));
            }
        })));
    }

    private static class DeferredMethodInteceptor
    implements MethodInterceptor {
        private DeferredMethodInteceptor() {
        }

        public Object intercept(Object self, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Deferred deferred = (Deferred)DEFERRED.get();
            DEFERRED.set(new DeferredInvoke(deferred, method, args));
            Class<?> resultType = method.getReturnType();
            if (resultType.equals(Byte.class) || resultType.equals(Byte.TYPE)) {
                return new Byte(0);
            }
            if (resultType.equals(Short.class) || resultType.equals(Short.TYPE)) {
                return new Short(0);
            }
            if (resultType.equals(Integer.class) || resultType.equals(Integer.TYPE)) {
                return new Integer(0);
            }
            if (resultType.equals(Long.class) || resultType.equals(Long.TYPE)) {
                return new Long(0L);
            }
            if (resultType.equals(Float.class) || resultType.equals(Float.TYPE)) {
                return new Float(0.0);
            }
            if (resultType.equals(Double.class) || resultType.equals(Double.TYPE)) {
                return new Double(0.0);
            }
            if (resultType.equals(Character.class) || resultType.equals(Character.TYPE)) {
                return new Character(' ');
            }
            if (resultType.equals(Boolean.class) || resultType.equals(Boolean.TYPE)) {
                return new Boolean(false);
            }
            if (resultType.equals(AtomicBoolean.class)) {
                return new AtomicBoolean(false);
            }
            if (resultType.equals(AtomicInteger.class)) {
                return new AtomicInteger(0);
            }
            if (resultType.equals(AtomicLong.class)) {
                return new AtomicLong(0L);
            }
            if (resultType.isEnum()) {
                return null;
            }
            if (resultType.isArray()) {
                return Array.newInstance(resultType.getComponentType(), 0);
            }
            if (resultType.equals(String.class)) {
                return "";
            }
            return ReflectionHelper.createProxyOf(resultType, (MethodInterceptor)new DeferredMethodInteceptor());
        }
    }
}

