/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.deferred;

import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TemporarilyUnavailableException;
import java.util.concurrent.Callable;

public class DeferredCallable<T>
implements Deferred<T> {
    private Callable<T> callable;
    private Class<T> deferredClass;

    public DeferredCallable(Callable<T> callable, Class<T> deferredClass) {
        this.callable = callable;
        this.deferredClass = deferredClass;
    }

    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        try {
            return this.callable.call();
        }
        catch (Exception e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.deferredClass;
    }
}

