/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools;

import com.oracle.tools.ComposableOption;
import com.oracle.tools.Option;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Logger;

public class Options {
    private static Logger LOGGER = Logger.getLogger(Options.class.getName());
    private LinkedHashMap<Class<Option>, Option> options = new LinkedHashMap();
    private HashSet<Option> usedOptions = new HashSet();

    public Options(Option ... options) {
        if (options != null) {
            for (Option option : options) {
                this.add(option);
            }
        }
    }

    public Options addIfAbsent(Option option) {
        Class<Option> classOfOption = Options.getClassOfOption(option);
        if (!this.options.containsKey(classOfOption)) {
            this.options.put(classOfOption, option);
        }
        return this;
    }

    public Options add(Option option) {
        Class<Option> classOfOption = Options.getClassOfOption(option);
        Option existingOption = this.options.get(classOfOption);
        if (existingOption instanceof ComposableOption) {
            ComposableOption composedOption = ((ComposableOption)existingOption).compose((ComposableOption)option);
            this.options.put(classOfOption, composedOption);
        } else {
            this.options.put(classOfOption, option);
        }
        this.usedOptions.remove(option);
        return this;
    }

    public Options addAll(Option ... options) {
        if (options != null) {
            for (Option option : options) {
                this.add(option);
            }
        }
        return this;
    }

    public Options replace(Option option) {
        Class<Option> classOfOption = Options.getClassOfOption(option);
        this.options.put(classOfOption, option);
        this.usedOptions.remove(option);
        return this;
    }

    public <T extends Option> boolean remove(Class<T> optionClass) {
        Class<Option> classOfOption = Options.getClassOfOption(optionClass);
        Option option = (Option)this.options.remove(classOfOption);
        this.usedOptions.remove(option);
        return option != null;
    }

    public <T extends Option> T get(Class<T> optionClass) {
        Class<Option> classOfOption = Options.getClassOfOption(optionClass);
        return classOfOption == null ? null : this.get(optionClass, null);
    }

    public <T extends Option> T get(Class<T> optionClass, T defaultIfNotDefined) {
        Class<Option> classOfOption = Options.getClassOfOption(optionClass);
        Option option = this.options.get(classOfOption);
        if (option == null) {
            return defaultIfNotDefined;
        }
        this.usedOptions.add(option);
        return (T)option;
    }

    public boolean contains(Class<Option> optionClass) {
        return this.get(optionClass) != null;
    }

    public boolean contains(Option option) {
        return this.get(option.getClass()).equals(option);
    }

    public <T> Iterable<T> getAll(Class<T> instanceOf) {
        LinkedList<Option> list = new LinkedList<Option>();
        for (Option option : this.options.values()) {
            if (!instanceOf.isInstance(option)) continue;
            list.add(option);
        }
        return list;
    }

    public Option[] asArray() {
        Option[] optionArray = new Option[this.options.size()];
        int i = 0;
        for (Option option : this.options.values()) {
            optionArray[i++] = option;
        }
        return optionArray;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Options{");
        boolean first = true;
        for (Option option : this.options.values()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(option);
        }
        builder.append("}");
        return builder.toString();
    }

    public static Class<Option> getClassOfOption(Option option) {
        return option == null ? null : Options.getClassOfOption(option.getClass());
    }

    public static Class<Option> getClassOfOption(Class<?> aClass) {
        Stack<Class<Option>> hierarchy = new Stack<Class<Option>>();
        while (aClass != null) {
            hierarchy.push(aClass);
            for (Class<Option> clazz : aClass.getInterfaces()) {
                if (Option.class.equals(clazz) || ComposableOption.class.equals(clazz)) {
                    while (aClass != null && Modifier.isAbstract(aClass.getModifiers()) && !aClass.isInterface()) {
                        aClass = hierarchy.isEmpty() ? null : (Class)hierarchy.pop();
                    }
                    return aClass;
                }
                if (!Option.class.isAssignableFrom(clazz)) continue;
                while (aClass != null && Modifier.isAbstract(aClass.getModifiers()) && !aClass.isInterface()) {
                    aClass = hierarchy.isEmpty() ? null : (Class)hierarchy.pop();
                }
                if (aClass == null) {
                    return null;
                }
                return clazz;
            }
            aClass = aClass.getSuperclass();
        }
        return null;
    }
}

