/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.subscribers;

import com.espertech.esper.client.EPServiceProvider;
import java.io.IOException;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopicListener
implements MessageListener {
    private final Logger log = LoggerFactory.getLogger(TopicListener.class);
    private final String esperTopicKey;
    private final ObjectMapper mapper;
    private final EPServiceProvider esperSink;

    public TopicListener(String esperTopicKey, EPServiceProvider esperSink) {
        this.esperTopicKey = esperTopicKey;
        this.esperSink = esperSink;
        this.mapper = new ObjectMapper();
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            TextMessage txtMsg = (TextMessage)message;
            String txt = null;
            try {
                txt = txtMsg.getText();
                this.log.debug("Received a message, yay!\n" + txt);
                Map event = (Map)this.mapper.readValue(txt, Map.class);
                this.esperSink.getEPRuntime().sendEvent(event, this.esperTopicKey);
            }
            catch (JMSException ex) {
                this.log.warn("Got an error from the message queue", (Throwable)ex);
            }
            catch (ClassCastException ex) {
                this.log.info("Received message that I couldn't parse: " + txt, (Throwable)ex);
            }
            catch (JsonMappingException ex) {
                this.log.info("Received message that I couldn't parse: " + txt, (Throwable)ex);
            }
            catch (JsonParseException ex) {
                this.log.info("Received message that I couldn't parse: " + txt, (Throwable)ex);
            }
            catch (IOException ex) {
                this.log.warn("Got an error from the message queue", (Throwable)ex);
            }
        } else if (message instanceof BytesMessage) {
            long llen;
            BytesMessage byteMessage = (BytesMessage)message;
            try {
                llen = byteMessage.getBodyLength();
            }
            catch (JMSException e) {
                this.log.warn("Unable to get message length", (Throwable)e);
                return;
            }
            if (llen > Integer.MAX_VALUE) {
                this.log.error("Ridiculously huge message payload, above 32-bit length");
            } else {
                int readLen;
                int len = (int)llen;
                byte[] data = new byte[len];
                try {
                    readLen = byteMessage.readBytes(data);
                }
                catch (JMSException e) {
                    this.log.warn("Unable to get message bytes", (Throwable)e);
                    return;
                }
                if (readLen < len) {
                    this.log.error("Failed to read byte message contents; read {}, was trying to read {}", (Object)readLen, (Object)data.length);
                } else {
                    try {
                        Map event = (Map)this.mapper.readValue(data, Map.class);
                        this.esperSink.getEPRuntime().sendEvent(event, this.esperTopicKey);
                    }
                    catch (IOException e) {
                        this.log.error("Failed to convert message to Esper Event", (Object)readLen, (Object)data.length);
                    }
                }
            }
        } else {
            this.log.error("Unexpected message type '{}' from AMQ broker: must skip", (Object)message.getClass().getName());
        }
    }
}

