/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.subscribers;

import com.espertech.esper.client.EPServiceProvider;
import com.google.inject.Inject;
import com.ning.metrics.meteo.subscribers.Subscriber;
import com.ning.metrics.meteo.subscribers.SubscriberConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SubscribersCompiler {
    private final ArrayList<Subscriber> subscribers = new ArrayList();
    private static final Logger log = Logger.getLogger(SubscribersCompiler.class);

    @Inject
    public SubscribersCompiler(List<SubscriberConfig> subscribersConfigs, EPServiceProvider epService) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        for (SubscriberConfig subscriberConfig : subscribersConfigs) {
            Subscriber subscriber = SubscribersCompiler.instantiateSubscriber(epService, subscriberConfig);
            if (subscriber == null) continue;
            this.subscribers.add(subscriber);
        }
    }

    static Subscriber instantiateSubscriber(EPServiceProvider epService, SubscriberConfig subscriberConfig) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> subscriberKlass;
        if (subscriberConfig.getEventOutputName() == null) {
            throw new IllegalStateException("Esper topic key not specified!");
        }
        try {
            String subscriberKlassName = subscriberConfig.getType();
            subscriberKlass = Class.forName(subscriberKlassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class not found for: " + subscriberConfig.getType());
        }
        Constructor<?> constructor = null;
        Class<?> subscriberConfigKlass = null;
        for (Constructor<?> cstr : subscriberKlass.getConstructors()) {
            if (cstr.getParameterTypes().length != 2) continue;
            constructor = cstr;
            subscriberConfigKlass = cstr.getParameterTypes()[0];
        }
        if (constructor != null && subscriberConfigKlass != null) {
            if (subscriberConfig.isEnabled()) {
                return (Subscriber)constructor.newInstance(subscriberConfigKlass.cast(subscriberConfig), epService);
            }
            log.info((Object)("Skipping disabled subscriber: " + subscriberConfig.getName()));
            return null;
        }
        throw new IllegalArgumentException("Can't find a suitable constructor in subscribers class " + subscriberKlass);
    }

    public ArrayList<Subscriber> getSubscribers() {
        return this.subscribers;
    }

    public void startAll() {
        try {
            for (Subscriber subscriber : this.subscribers) {
                subscriber.subscribe();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Unable to start subscriber", (Throwable)ex);
        }
    }

    public void stopAll() {
        try {
            for (Subscriber subscriber : this.subscribers) {
                subscriber.unsubscribe();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

