/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.subscribers;

import com.espertech.esper.client.EPServiceProvider;
import com.ning.metrics.meteo.subscribers.JMXSubscriberConfig;
import com.ning.metrics.meteo.subscribers.Subscriber;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

class JMXSubscriber
implements Subscriber {
    private static final Logger log = Logger.getLogger(JMXSubscriber.class);
    private final JMXSubscriberConfig jmxConfig;
    private JMXConnector jmxConn;
    private MBeanServerConnection mbeanConn;
    private ObjectName mbeanName;
    private String[] attrNames;
    private EPServiceProvider esperSink;
    private AtomicBoolean closed = new AtomicBoolean(true);
    private ScheduledFuture<?> worker;

    public JMXSubscriber(JMXSubscriberConfig jmxConfig, EPServiceProvider esperSink) {
        this.jmxConfig = jmxConfig;
        this.esperSink = esperSink;
    }

    private void connect() throws IOException {
        String url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", this.jmxConfig.getHost(), this.jmxConfig.getPort());
        log.info((Object)("Connecting to: " + url));
        try {
            JMXServiceURL urlObj = new JMXServiceURL(url);
            this.jmxConn = JMXConnectorFactory.connect(urlObj);
            this.mbeanConn = this.jmxConn.getMBeanServerConnection();
            this.mbeanName = new ObjectName(this.jmxConfig.getQuery());
            this.attrNames = this.jmxConfig.getAttributes();
            this.closed.set(false);
        }
        catch (Exception ex) {
            if (this.jmxConn != null) {
                try {
                    this.jmxConn.close();
                    this.jmxConn = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new RuntimeException(ex);
        }
        log.info((Object)"Connected!");
    }

    @Override
    public void subscribe() {
        try {
            this.connect();
        }
        catch (IOException e) {
            return;
        }
        this.worker = Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    AttributeList attrList = JMXSubscriber.this.mbeanConn.getAttributes(JMXSubscriber.this.mbeanName, JMXSubscriber.this.attrNames);
                    LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                    log.debug((Object)String.format("Found %d data points", attrList.size()));
                    for (Object attrObj : attrList) {
                        Attribute attr = (Attribute)attrObj;
                        data.put(attr.getName(), attr.getValue());
                    }
                    log.debug((Object)("Received a message, yay!\n" + data));
                    JMXSubscriber.this.esperSink.getEPRuntime().sendEvent(data, JMXSubscriber.this.jmxConfig.getEventOutputName());
                }
                catch (InstanceNotFoundException ex) {
                    log.error((Object)"Could not fetch from JMX", (Throwable)ex);
                }
                catch (ReflectionException ex) {
                    log.error((Object)"Could not fetch from JMX", (Throwable)ex);
                }
                catch (IOException ex) {
                    log.error((Object)"Could not fetch from JMX", (Throwable)ex);
                }
            }
        }, 0L, this.jmxConfig.getPollIntervalInMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void unsubscribe() {
        this.worker.cancel(true);
        try {
            if (this.jmxConn != null) {
                this.jmxConn.close();
                this.jmxConn = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

