/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.subscribers;

import com.espertech.esper.client.EPServiceProvider;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.ning.metrics.meteo.subscribers.FileSubscriberConfig;
import com.ning.metrics.meteo.subscribers.Subscriber;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

class FileSubscriber
implements Subscriber {
    private final Logger log = Logger.getLogger(FileSubscriber.class);
    private final EPServiceProvider esperSink;
    private final FileSubscriberConfig subscriberConfig;
    private static final LinkedHashMap<String, Object> map = new LinkedHashMap();

    @Inject
    public FileSubscriber(FileSubscriberConfig subscriberConfig, EPServiceProvider esperSink) {
        this.subscriberConfig = subscriberConfig;
        this.esperSink = esperSink;
    }

    @Override
    public void subscribe() {
        ImmutableList<LinkedHashMap<String, Object>> dataPoints = this.getDataPoints();
        this.log.info((Object)String.format("Found %d data points", dataPoints.size()));
        for (LinkedHashMap s : dataPoints) {
            try {
                this.log.debug((Object)("Received a message, yay!\n" + s));
                this.esperSink.getEPRuntime().sendEvent((Map)s, this.subscriberConfig.getEventOutputName());
            }
            catch (ClassCastException ex) {
                this.log.info((Object)("Received message that I couldn't parse: " + s), (Throwable)ex);
            }
        }
    }

    @Override
    public void unsubscribe() {
    }

    private ImmutableList<LinkedHashMap<String, Object>> getDataPoints() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        try {
            for (String line : IOUtils.readLines((Reader)new FileReader(this.subscriberConfig.getFilePath()))) {
                if (line.trim().length() <= 0) continue;
                map.clear();
                String[] items = line.split(this.subscriberConfig.getSeparator());
                long dateTime = new DateTime((Object)items[0], DateTimeZone.forID((String)"UTC")).getMillis();
                map.put("timestamp", dateTime);
                for (int j = 1; j < items.length; ++j) {
                    double value = Double.valueOf(items[j]);
                    map.put(this.subscriberConfig.getAttributes()[j - 1], value);
                }
                builder.add(new LinkedHashMap<String, Object>(map));
            }
            return builder.build();
        }
        catch (IOException e) {
            this.log.error((Object)("Unable to read file: " + this.subscriberConfig.getFilePath()));
            return null;
        }
    }
}

