/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.server.resources;

import com.google.common.cache.Cache;
import com.google.inject.Singleton;
import com.ning.metrics.meteo.binder.StreamConfig;
import com.ning.metrics.meteo.publishers.PublishersCompiler;
import com.ning.metrics.meteo.publishers.ResourceListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.util.JSONPObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/rest/1.0")
public class StreamResource {
    private static final Logger log = LoggerFactory.getLogger(StreamResource.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final PublishersCompiler compiler;

    @Inject
    public StreamResource(PublishersCompiler compiler) {
        this.compiler = compiler;
    }

    @GET
    @Path(value="/{stream}/{attribute}")
    @Produces(value={"application/json"})
    public Response getSamplesByRoute(@QueryParam(value="callback") @DefaultValue(value="callback") String callback, @PathParam(value="stream") String stream, @PathParam(value="attribute") String attribute) {
        Cache<Object, Object> samplesCache = null;
        ResourceListener resourceListener = (ResourceListener)this.compiler.getPublisherInstances().get(stream);
        if (resourceListener != null) {
            Map<String, Cache<Object, Object>> samples = resourceListener.getSamplesCache();
            samplesCache = samples.get(attribute);
        }
        return this.buildJsonpResponse(attribute, samplesCache, callback);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addStream(StreamConfig streamConfig) {
        if (this.compiler.getPublisherInstances().get(streamConfig.getName()) != null) {
            return Response.status((Response.Status)Response.Status.CONFLICT).header("Warning", (Object)"199 Stream already exists").build();
        }
        try {
            this.compiler.addStream(streamConfig);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Warning", (Object)("199 " + e.toString())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private Response buildJsonpResponse(String attribute, Cache<Object, Object> samples, String callback) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JsonGenerator generator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)out);
            generator.writeStartObject();
            generator.writeFieldName("attribute");
            generator.writeString(attribute);
            generator.writeFieldName("samples");
            generator.writeStartArray();
            if (samples != null) {
                ConcurrentMap samplesForType = samples.asMap();
                ArrayList<DateTime> timestamps = new ArrayList<DateTime>();
                for (Object k : samplesForType.keySet()) {
                    timestamps.add((DateTime)k);
                }
                Collections.sort(timestamps);
                for (DateTime dateTime : timestamps) {
                    Object dataPoint = samplesForType.get(dateTime);
                    if (dataPoint == null) continue;
                    generator.writeNumber(StreamResource.unixSeconds(dateTime));
                    generator.writeObject(dataPoint);
                }
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.close();
            JSONPObject object = new JSONPObject(callback, (Object)out.toString());
            return Response.ok((Object)object).build();
        }
        catch (IOException e) {
            log.error("Error", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public static int unixSeconds(DateTime dateTime) {
        long millis = dateTime.toDateTime(DateTimeZone.UTC).getMillis();
        return (int)(millis / 1000L);
    }
}

