/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.server;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.ning.metrics.meteo.binder.RealtimeSystemConfig;
import com.ning.metrics.meteo.server.SetupJULBridge;
import java.util.EnumSet;
import java.util.EventListener;
import javax.management.MBeanServer;
import javax.servlet.DispatcherType;
import org.apache.log4j.Logger;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.log.Log;

public class JettyServer {
    private static final Logger log = Logger.getLogger(JettyServer.class);
    private final RealtimeSystemConfig config;
    private final MBeanServer mbeanServer;
    private Server server;

    @Inject
    public JettyServer(RealtimeSystemConfig config, MBeanServer mbeanServer) {
        this.config = config;
        this.mbeanServer = mbeanServer;
    }

    public void start(final Injector injector) throws Exception {
        long startTime = System.currentTimeMillis();
        this.server = new Server();
        MBeanContainer mbContainer = new MBeanContainer(this.mbeanServer);
        this.server.getContainer().addEventListener((Container.Listener)mbContainer);
        this.server.addBean((Object)mbContainer);
        mbContainer.addBean((Object)Log.getLog());
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setStatsOn(this.config.isJettyStatsOn());
        connector.setHost(this.config.getLocalIp());
        connector.setPort(this.config.getLocalPort());
        this.server.addConnector((Connector)connector);
        this.server.setStopAtShutdown(true);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, "/", 1);
        context.setContextPath("/");
        context.addEventListener((EventListener)new GuiceServletContextListener(){

            protected Injector getInjector() {
                return injector;
            }
        });
        SetupJULBridge listener = new SetupJULBridge();
        context.addEventListener((EventListener)((Object)listener));
        FilterHolder filterHolder = new FilterHolder(GuiceFilter.class);
        context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
        ServletHolder sh = new ServletHolder(DefaultServlet.class);
        context.addServlet(sh, "/*");
        this.server.start();
        long secondsToStart = (System.currentTimeMillis() - startTime) / 1000L;
        log.info((Object)String.format("Jetty server started in %d:%02d", secondsToStart / 60L, secondsToStart % 60L));
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            log.warn((Object)"Got exception trying to stop Jetty", (Throwable)e);
        }
    }
}

