/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.ning.metrics.meteo.publishers.ResourcePublisherConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ResourceListener
implements UpdateListener {
    private final ResourcePublisherConfig config;
    private final Map<String, Cache<Object, Object>> samplesCache = Maps.newConcurrentMap();
    private final Object mapLock = new Object();

    public ResourceListener(ResourcePublisherConfig config) {
        this.config = config;
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null) {
            for (EventBean newEvent : newEvents) {
                for (String attribute : newEvent.getEventType().getPropertyNames()) {
                    this.add(attribute, new DateTime(DateTimeZone.UTC), newEvent.get(attribute));
                }
            }
        }
    }

    public Map<String, Cache<Object, Object>> getSamplesCache() {
        return this.samplesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String attribute, DateTime dateTime, Object sample) {
        Cache samplesForType = this.samplesCache.get(attribute);
        if (samplesForType == null) {
            Object object = this.mapLock;
            synchronized (object) {
                samplesForType = this.samplesCache.get(attribute);
                if (samplesForType == null) {
                    samplesForType = CacheBuilder.newBuilder().maximumSize(this.config.getCacheMaxSize()).expireAfterWrite(this.config.getCacheExpirySeconds(), TimeUnit.SECONDS).build();
                    this.samplesCache.put(attribute, (Cache<Object, Object>)samplesForType);
                }
            }
        }
        samplesForType.put((Object)dateTime, sample);
    }
}

