/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

class ResmonPublisher {
    private final Map<String, Object> currentMetrics = new ConcurrentHashMap<String, Object>();

    public ResmonPublisher() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            }

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.setContentType("text/xml; encoding=UTF-8");
                response.setStatus(200);
                response.getWriter().println(ResmonPublisher.this.writeResmon());
                ((Request)request).setHandled(true);
            }
        };
        Server server = new Server(8083);
        server.setHandler((Handler)handler);
        server.start();
    }

    private String writeResmon() {
        StringBuilder builder = new StringBuilder();
        builder.setLength(0);
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        builder.append("<?xml-stylesheet type=\"text/xsl\" href=\"resmon.xsl\"?>\n");
        builder.append("<ResmonResults>\n");
        builder.append(String.format("\t<ResmonResult module=\"%s\" service=\"%s\">\n", "amq", "graphing"));
        builder.append(String.format("\t\t<last_runtime_seconds>%d</last_runtime_seconds>\n", 0));
        builder.append(String.format("\t\t<last_update>%d</last_update>\n", System.currentTimeMillis()));
        for (String metric : this.currentMetrics.keySet()) {
            builder.append(String.format("\t\t<metric name=\"%s\" type=\"%s\">%s</metric>\n", metric, Character.valueOf('n'), this.currentMetrics.get(metric)));
        }
        builder.append(String.format("\t\t<state>%s</state>\n\t</ResmonResult>\n", "OK"));
        builder.append("</ResmonResults>\n");
        return builder.toString();
    }

    public void send(String metric, Object value) {
        this.currentMetrics.put(metric, value);
    }
}

