/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.UpdateListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.ning.metrics.meteo.binder.StreamConfig;
import com.ning.metrics.meteo.publishers.PublisherConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class PublishersCompiler {
    private static final Logger log = Logger.getLogger(PublishersCompiler.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, PublisherConfig> publisherConfigs = new LinkedHashMap<String, PublisherConfig>();
    private final Map<String, UpdateListener> publisherInstances = new LinkedHashMap<String, UpdateListener>();
    private final Map<String, StreamConfig> streamConfigs = new LinkedHashMap<String, StreamConfig>();
    private final EPServiceProvider epService;

    @Inject
    public PublishersCompiler(List<PublisherConfig> publisherConfigs, List<StreamConfig> streamConfigs, EPServiceProvider epService) {
        this.epService = epService;
        for (PublisherConfig globalPublisherConfig : publisherConfigs) {
            this.publisherConfigs.put(globalPublisherConfig.getName(), globalPublisherConfig);
        }
        try {
            for (StreamConfig stream : streamConfigs) {
                this.addStream(stream);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Could not instantiate the publishers", (Throwable)ex);
        }
    }

    public Map<String, UpdateListener> getPublisherInstances() {
        return this.publisherInstances;
    }

    public Map<String, PublisherConfig> getPublisherConfigs() {
        return this.publisherConfigs;
    }

    public Map<String, StreamConfig> getStreamConfigs() {
        return this.streamConfigs;
    }

    public void addStream(StreamConfig streamConfig) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.configurePublishersForStream(streamConfig);
        LinkedHashMap<String, UpdateListener> publishers = new LinkedHashMap<String, UpdateListener>();
        for (PublisherConfig route : streamConfig.getPublishers()) {
            UpdateListener updateListener = PublishersCompiler.instantiateUpdateListener(route);
            publishers.put(route.getType(), updateListener);
            this.publisherInstances.put(streamConfig.getName(), updateListener);
        }
        for (String sqlStatement : streamConfig.getSql()) {
            EPStatement epl = this.epService.getEPAdministrator().createEPL(sqlStatement);
            for (String publisherType : publishers.keySet()) {
                log.info((Object)String.format("Added publisher [%-50s] to [%s]", publisherType, sqlStatement));
                epl.addListener((UpdateListener)publishers.get(publisherType));
            }
            epl.start();
        }
    }

    @VisibleForTesting
    void configurePublishersForStream(StreamConfig streamConfig) {
        ArrayList<PublisherConfig> newRoutes = new ArrayList<PublisherConfig>();
        for (HashMap<String, Object> overrides : streamConfig.getRoutes()) {
            String routeName = (String)overrides.get("name");
            PublisherConfig associatedGlobalPublisherConfig = this.publisherConfigs.get(routeName);
            if (associatedGlobalPublisherConfig == null) continue;
            Map base = (Map)mapper.convertValue((Object)associatedGlobalPublisherConfig, (TypeReference)new TypeReference<Map<String, Object>>(){});
            for (String key : overrides.keySet()) {
                if (overrides.get(key) == null) continue;
                base.put(key, overrides.get(key));
            }
            newRoutes.add((PublisherConfig)mapper.convertValue((Object)base, associatedGlobalPublisherConfig.getClass()));
        }
        streamConfig.setPublishers(newRoutes);
        this.streamConfigs.put(streamConfig.getName(), streamConfig);
    }

    @VisibleForTesting
    static UpdateListener instantiateUpdateListener(PublisherConfig publisherConfig) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        UpdateListener listener;
        String listenerType = publisherConfig.getType();
        Class<?> listenerClass = Class.forName(listenerType);
        Constructor<?> defaultConstructor = null;
        Constructor<?> configConstructor = null;
        for (Constructor<?> constructor : listenerClass.getConstructors()) {
            if (constructor.getParameterTypes() == null || constructor.getParameterTypes().length == 0) {
                defaultConstructor = constructor;
                continue;
            }
            if (constructor.getParameterTypes().length != 1) continue;
            configConstructor = constructor;
        }
        if (configConstructor != null) {
            Class<?> listenerConfigClass = configConstructor.getParameterTypes()[0];
            listener = (UpdateListener)configConstructor.newInstance(listenerConfigClass.cast(publisherConfig));
        } else if (defaultConstructor != null) {
            listener = (UpdateListener)defaultConstructor.newInstance(new Object[0]);
        } else {
            throw new IllegalArgumentException("Can't find a suitable constructor in subscribers class " + listenerClass.getName());
        }
        return listener;
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }
}

